/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.CreateLayerRequest;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLayerRequestMarshaller
implements Marshaller<Request<CreateLayerRequest>, CreateLayerRequest> {
    @Override
    public Request<CreateLayerRequest> marshall(CreateLayerRequest createLayerRequest) {
        if (createLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLayerRequest> request = new DefaultRequest<CreateLayerRequest>(createLayerRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateLayer";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            Recipes customRecipes;
            List<VolumeConfiguration> volumeConfigurationsList;
            List<String> packagesList;
            List<String> customSecurityGroupIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createLayerRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createLayerRequest.getStackId());
            }
            if (createLayerRequest.getType() != null) {
                jsonWriter.key("Type").value(createLayerRequest.getType());
            }
            if (createLayerRequest.getName() != null) {
                jsonWriter.key("Name").value(createLayerRequest.getName());
            }
            if (createLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value(createLayerRequest.getShortname());
            }
            if (createLayerRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : createLayerRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value(createLayerRequest.getCustomInstanceProfileArn());
            }
            if ((customSecurityGroupIdsList = createLayerRequest.getCustomSecurityGroupIds()) != null && customSecurityGroupIdsList.size() > 0) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value(customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if ((packagesList = createLayerRequest.getPackages()) != null && packagesList.size() > 0) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value(packagesListValue);
                }
                jsonWriter.endArray();
            }
            if ((volumeConfigurationsList = createLayerRequest.getVolumeConfigurations()) != null && volumeConfigurationsList.size() > 0) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    jsonWriter.object();
                    if (volumeConfigurationsListValue.getMountPoint() != null) {
                        jsonWriter.key("MountPoint").value(volumeConfigurationsListValue.getMountPoint());
                    }
                    if (volumeConfigurationsListValue.getRaidLevel() != null) {
                        jsonWriter.key("RaidLevel").value(volumeConfigurationsListValue.getRaidLevel());
                    }
                    if (volumeConfigurationsListValue.getNumberOfDisks() != null) {
                        jsonWriter.key("NumberOfDisks").value(volumeConfigurationsListValue.getNumberOfDisks());
                    }
                    if (volumeConfigurationsListValue.getSize() != null) {
                        jsonWriter.key("Size").value(volumeConfigurationsListValue.getSize());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createLayerRequest.isEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value(createLayerRequest.isEnableAutoHealing());
            }
            if (createLayerRequest.isAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value(createLayerRequest.isAutoAssignElasticIps());
            }
            if ((customRecipes = createLayerRequest.getCustomRecipes()) != null) {
                List<String> shutdownList;
                List<String> undeployList;
                List<String> deployList;
                List<String> configureList;
                jsonWriter.key("CustomRecipes");
                jsonWriter.object();
                List<String> setupList = customRecipes.getSetup();
                if (setupList != null && setupList.size() > 0) {
                    jsonWriter.key("Setup");
                    jsonWriter.array();
                    for (String setupListValue : setupList) {
                        if (setupListValue == null) continue;
                        jsonWriter.value(setupListValue);
                    }
                    jsonWriter.endArray();
                }
                if ((configureList = customRecipes.getConfigure()) != null && configureList.size() > 0) {
                    jsonWriter.key("Configure");
                    jsonWriter.array();
                    for (String configureListValue : configureList) {
                        if (configureListValue == null) continue;
                        jsonWriter.value(configureListValue);
                    }
                    jsonWriter.endArray();
                }
                if ((deployList = customRecipes.getDeploy()) != null && deployList.size() > 0) {
                    jsonWriter.key("Deploy");
                    jsonWriter.array();
                    for (String deployListValue : deployList) {
                        if (deployListValue == null) continue;
                        jsonWriter.value(deployListValue);
                    }
                    jsonWriter.endArray();
                }
                if ((undeployList = customRecipes.getUndeploy()) != null && undeployList.size() > 0) {
                    jsonWriter.key("Undeploy");
                    jsonWriter.array();
                    for (String undeployListValue : undeployList) {
                        if (undeployListValue == null) continue;
                        jsonWriter.value(undeployListValue);
                    }
                    jsonWriter.endArray();
                }
                if ((shutdownList = customRecipes.getShutdown()) != null && shutdownList.size() > 0) {
                    jsonWriter.key("Shutdown");
                    jsonWriter.array();
                    for (String shutdownListValue : shutdownList) {
                        if (shutdownListValue == null) continue;
                        jsonWriter.value(shutdownListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

