package io.intino.consul.framework.utils;

import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;

import java.io.IOException;

public class JMXConnection implements AutoCloseable {
	private final Activity.System.OperatingSystem os;
	private int port = 0;
	private JMXClient.JMXConnection connection;

	public static JMXConnection connection(Activity.System system, String chain) throws IOException {
		try {
			JMXConnection connection = new JMXConnection(system.operatingSystem(), chain);
			if (connection.get() == null) throw new IOException("Connection null");
			return connection;
		} catch (Exception e) {
			throw new IOException(e.getMessage());
		}
	}


	private JMXConnection(Activity.System.OperatingSystem os, String chain) {
		this.os = os;
		try {
			if (chain.contains("\0\0")) {
				String[] split = chain.split("\0\0");
				this.port = os.createConnection(Integer.parseInt(split[1]));
				this.connection = new JMXClient("localhost", port).connect();
			} else connection = new JMXClient(chain).connect();
		} catch (Exception e) {
			Logger.trace(e.getMessage());
			if (port != 0) os.removeConnection(port);
		} finally {
			if (connection == null && port != 0) os.removeConnection(port);
		}
	}

	public JMXClient.JMXConnection get() {
		return connection;
	}

	@Override
	public void close() {
		if (connection != null) connection.close();
		if (port != 0) os.removeConnection(port);
	}
}
