/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.type;

import org.apache.commons.math3.exception.NotPositiveException;

public class TesparSymbol {
    private final int duration;
    private final int shape;
    private final double amplitude;

    public TesparSymbol(int duration, int shape, double amplitude) {
        this.duration = duration;
        this.shape = shape;
        if (amplitude < 0.0) {
            throw new NotPositiveException(amplitude);
        }
        this.amplitude = amplitude;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getShape() {
        return this.shape;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TesparSymbol)) {
            return false;
        }
        TesparSymbol other = (TesparSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getShape() != other.getShape()) {
            return false;
        }
        return Double.compare(this.getAmplitude(), other.getAmplitude()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TesparSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getShape();
        long $amplitude = Double.doubleToLongBits(this.getAmplitude());
        result = result * 59 + (int)($amplitude >>> 32 ^ $amplitude);
        return result;
    }

    public String toString() {
        return "TesparSymbol(duration=" + this.getDuration() + ", shape=" + this.getShape() + ", amplitude=" + this.getAmplitude() + ")";
    }
}

