/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.transform.DctNormalization;
import org.apache.commons.math3.transform.FastCosineTransformer;
import org.apache.commons.math3.transform.TransformType;
import ro.hasna.ts.math.representation.GenericTransformer;

public class DiscreteCosineTransform
implements GenericTransformer<double[], double[]> {
    private static final long serialVersionUID = -100136722639862251L;
    private final FastCosineTransformer cosineTransformer;

    public DiscreteCosineTransform() {
        this(new FastCosineTransformer(DctNormalization.STANDARD_DCT_I));
    }

    public DiscreteCosineTransform(FastCosineTransformer cosineTransformer) {
        this.cosineTransformer = cosineTransformer;
    }

    @Override
    public double[] transform(double[] values) {
        int initialLength = values.length;
        int powerOfTwo = Integer.highestOneBit(initialLength);
        int requiredLength = powerOfTwo + 1;
        if (initialLength != requiredLength && initialLength != powerOfTwo) {
            requiredLength = (powerOfTwo << 1) + 1;
        }
        double[] copy = new double[requiredLength];
        System.arraycopy(values, 0, copy, 0, initialLength);
        double[] transform = this.cosineTransformer.transform(copy, TransformType.FORWARD);
        int outputLength = (powerOfTwo >> 1) + 1;
        double[] result = new double[outputLength];
        for (int i = 0; i < outputLength && i < transform.length; ++i) {
            result[i] = transform[i];
        }
        return result;
    }
}

