/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import java.util.LinkedList;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.exception.util.LocalizableMessages;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.normalization.Normalizer;
import ro.hasna.ts.math.normalization.ZNormalizer;

public class DynamicTimeWarpingDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = 1154818905340336905L;
    private final double radiusPercentage;
    private final Normalizer normalizer;

    public DynamicTimeWarpingDistance() {
        this(0.05, new ZNormalizer());
    }

    public DynamicTimeWarpingDistance(double radiusPercentage, Normalizer normalizer) {
        if (radiusPercentage < 0.0 || radiusPercentage > 1.0) {
            throw new OutOfRangeException(LocalizableMessages.OUT_OF_RANGE_BOTH_INCLUSIVE, (Number)radiusPercentage, 0, 1);
        }
        this.radiusPercentage = radiusPercentage;
        this.normalizer = normalizer;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        if (this.normalizer != null) {
            a = this.normalizer.normalize(a);
            b = this.normalizer.normalize(b);
        }
        int n = a.length;
        int radius = (int)((double)n * this.radiusPercentage);
        double transformedCutOff = this.distance(cutOffValue, 0.0);
        if (this.computeModifiedKimLowerBound(a, b, n, transformedCutOff) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        LowerBound keoghLowerBound = this.computeKeoghLowerBound(a, b, n, radius, transformedCutOff);
        if (keoghLowerBound.value == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        LowerBound lemireLowerBound = this.computeLemireLowerBound(b, keoghLowerBound, n, radius, transformedCutOff);
        if (lemireLowerBound.value == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        double[] cumulativeErrorMargins = lemireLowerBound.errorMargins;
        for (int i = cumulativeErrorMargins.length - 2; i >= 0; --i) {
            int n2 = i;
            cumulativeErrorMargins[n2] = cumulativeErrorMargins[n2] + cumulativeErrorMargins[i + 1];
        }
        return this.computeDtw(a, b, n, radius, cumulativeErrorMargins, transformedCutOff);
    }

    protected double computeModifiedKimLowerBound(double[] a, double[] b, int n, double transformedCutOff) {
        double d = this.distance(a[0], b[0]) + this.distance(a[n - 1], b[n - 1]);
        if (d >= transformedCutOff) {
            return Double.POSITIVE_INFINITY;
        }
        if ((d += FastMath.min(this.distance(a[1], b[0]), FastMath.min(this.distance(a[0], b[1]), this.distance(a[1], b[1])))) >= transformedCutOff) {
            return Double.POSITIVE_INFINITY;
        }
        if ((d += FastMath.min(this.distance(a[n - 1], b[n - 2]), FastMath.min(this.distance(a[n - 2], b[n - 1]), this.distance(a[n - 2], b[n - 2])))) >= transformedCutOff) {
            return Double.POSITIVE_INFINITY;
        }
        double m1 = FastMath.min(this.distance(a[0], b[2]), this.distance(a[1], b[2]));
        double m2 = FastMath.min(this.distance(a[2], b[0]), this.distance(a[2], b[1]));
        if ((d += FastMath.min(this.distance(a[2], b[2]), FastMath.min(m1, m2))) >= transformedCutOff) {
            return Double.POSITIVE_INFINITY;
        }
        m1 = FastMath.min(this.distance(a[n - 1], b[n - 3]), this.distance(a[n - 2], b[n - 3]));
        m2 = FastMath.min(this.distance(a[n - 3], b[n - 1]), this.distance(a[n - 3], b[n - 2]));
        if ((d += FastMath.min(this.distance(a[n - 3], b[n - 3]), FastMath.min(m1, m2))) >= transformedCutOff) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    protected LowerBound computeLemireLowerBound(double[] v, LowerBound keoghLowerBound, int n, int radius, double transformedCutOff) {
        LowerBound improvedLowerBound = this.computeKeoghLowerBound(v, keoghLowerBound.projection, n, radius, transformedCutOff - keoghLowerBound.value);
        if (improvedLowerBound.value != Double.POSITIVE_INFINITY) {
            for (int i = 0; i < improvedLowerBound.errorMargins.length; ++i) {
                int n2 = i;
                improvedLowerBound.errorMargins[n2] = improvedLowerBound.errorMargins[n2] + keoghLowerBound.errorMargins[i];
            }
            improvedLowerBound.value += keoghLowerBound.value;
        }
        return improvedLowerBound;
    }

    protected LowerBound computeKeoghLowerBound(double[] a, double[] b, int n, int radius, double transformedCutOff) {
        double value = 0.0;
        double[] projection = new double[n];
        double[] errorMargins = new double[n];
        Envelope envelope = this.computeLemireEnvelope(b, n, radius);
        for (int i = 0; i < n; ++i) {
            double min = envelope.lower[i];
            double max = envelope.upper[i];
            double d = 0.0;
            if (a[i] > max) {
                d = this.distance(a[i], max);
                projection[i] = max;
            } else if (a[i] < min) {
                d = this.distance(a[i], min);
                projection[i] = min;
            } else {
                projection[i] = a[i];
            }
            errorMargins[i] = d;
            value += d;
            if (!(value >= transformedCutOff)) continue;
            return new LowerBound(Double.POSITIVE_INFINITY, projection, errorMargins);
        }
        return new LowerBound(value, projection, errorMargins);
    }

    protected Envelope computeLemireEnvelope(double[] v, int n, int radius) {
        int i;
        int w = 2 * radius + 1;
        double[] upper = new double[n];
        double[] lower = new double[n];
        LinkedList<Integer> upperList = new LinkedList<Integer>();
        LinkedList<Integer> lowerList = new LinkedList<Integer>();
        upperList.addLast(0);
        lowerList.addLast(0);
        for (i = 1; i < n; ++i) {
            if (i >= w) {
                upper[i - w] = v[(Integer)upperList.getFirst()];
                lower[i - w] = v[(Integer)lowerList.getFirst()];
            }
            if (v[i] > v[i - 1]) {
                upperList.removeLast();
                while (!upperList.isEmpty() && v[i] > v[(Integer)upperList.getLast()]) {
                    upperList.removeLast();
                }
            } else {
                lowerList.removeLast();
                while (!lowerList.isEmpty() && v[i] < v[(Integer)lowerList.getLast()]) {
                    lowerList.removeLast();
                }
            }
            upperList.addLast(i);
            lowerList.addLast(i);
            if (i == 2 * w + (Integer)upperList.getFirst()) {
                upperList.removeFirst();
                continue;
            }
            if (i != 2 * w + (Integer)lowerList.getFirst()) continue;
            lowerList.removeFirst();
        }
        for (i = n; i < n + w; ++i) {
            upper[i - w] = v[(Integer)upperList.getFirst()];
            lower[i - w] = v[(Integer)lowerList.getFirst()];
            if (i - (Integer)upperList.getFirst() >= 2 * w) {
                upperList.removeFirst();
            }
            if (i - (Integer)lowerList.getFirst() < 2 * w) continue;
            lowerList.removeFirst();
        }
        return new Envelope(lower, upper);
    }

    protected double computeDtw(double[] a, double[] b, int n, int radius, double[] cumulativeErrorMargins, double transformedCutOff) {
        int i;
        int w = 2 * radius + 1;
        double[] cost = new double[w];
        double[] prevCost = new double[w];
        int k = 0;
        for (i = 0; i < w; ++i) {
            cost[i] = Double.POSITIVE_INFINITY;
            prevCost[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < n; ++i) {
            k = FastMath.max(0, radius - i);
            double min = Double.POSITIVE_INFINITY;
            int start = FastMath.max(0, i - radius);
            int end = FastMath.min(n - 1, i + radius);
            int j = start;
            while (j <= end) {
                if (i == 0 && j == 0) {
                    cost[k] = this.distance(a[0], b[0]);
                    min = cost[k];
                } else {
                    double y = j - 1 < 0 || k - 1 < 0 ? Double.POSITIVE_INFINITY : cost[k - 1];
                    double x = i - 1 < 0 || k + 1 > 2 * radius ? Double.POSITIVE_INFINITY : prevCost[k + 1];
                    double z = i - 1 < 0 || j - 1 < 0 ? Double.POSITIVE_INFINITY : prevCost[k];
                    cost[k] = this.distance(a[i], b[j]) + FastMath.min(x, FastMath.min(y, z));
                    if (cost[k] < min) {
                        min = cost[k];
                    }
                }
                ++j;
                ++k;
            }
            if (i + radius < n - 1 && min + cumulativeErrorMargins[i + radius + 1] >= transformedCutOff) {
                return Double.POSITIVE_INFINITY;
            }
            System.arraycopy(cost, 0, prevCost, 0, w);
        }
        return this.postProcessDistance(prevCost[k - 1]);
    }

    protected double distance(double a, double b) {
        return (a - b) * (a - b);
    }

    protected double postProcessDistance(double d) {
        return FastMath.sqrt(d);
    }

    protected static class Envelope {
        double[] lower;
        double[] upper;

        Envelope(double[] lower, double[] upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    protected static class LowerBound {
        double value;
        double[] projection;
        double[] errorMargins;

        LowerBound(double value, double[] projection, double[] errorMargins) {
            this.value = value;
            this.projection = projection;
            this.errorMargins = errorMargins;
        }
    }
}

