/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;

public class ComplexityInvariantDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = 8279756267007620217L;
    private final GenericDistanceMeasure<double[]> baseDistance;

    public ComplexityInvariantDistance(GenericDistanceMeasure<double[]> baseDistance) {
        this.baseDistance = baseDistance;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutoffValue) {
        double complexityFactor = this.getComplexityFactor(a, b);
        double transformedCutoff = cutoffValue / complexityFactor;
        double d = this.baseDistance.compute(a, b, transformedCutoff);
        if (d >= transformedCutoff) {
            return Double.POSITIVE_INFINITY;
        }
        return d * complexityFactor;
    }

    protected double getComplexityFactor(double[] a, double[] b) {
        double lengthB;
        double lengthA = this.getSeriesLength(a);
        if (lengthA > (lengthB = this.getSeriesLength(b))) {
            return lengthA / lengthB;
        }
        return lengthB / lengthA;
    }

    protected double getSeriesLength(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length - 1; ++i) {
            sum += (v[i + 1] - v[i]) * (v[i + 1] - v[i]);
        }
        return FastMath.sqrt(sum);
    }

    public GenericDistanceMeasure<double[]> getBaseDistance() {
        return this.baseDistance;
    }
}

