/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.filter;

import org.apache.commons.math3.exception.OutOfRangeException;
import ro.hasna.ts.math.exception.util.LocalizableMessages;
import ro.hasna.ts.math.filter.Filter;

public class ExponentialMovingAverageFilter
implements Filter {
    private static final long serialVersionUID = -5033372522209156302L;
    private final double smoothingFactor;

    public ExponentialMovingAverageFilter(double smoothingFactor) {
        if (smoothingFactor <= 0.0 || smoothingFactor >= 1.0) {
            throw new OutOfRangeException(LocalizableMessages.OUT_OF_RANGE_BOTH_EXCLUSIVE, (Number)smoothingFactor, 0, 1);
        }
        this.smoothingFactor = smoothingFactor;
    }

    @Override
    public double[] filter(double[] values) {
        int length = values.length;
        double[] result = new double[length];
        result[0] = values[0];
        double k = 1.0 - this.smoothingFactor;
        for (int i = 1; i < length; ++i) {
            result[i] = values[i] * this.smoothingFactor + result[i - 1] * k;
        }
        return result;
    }
}

