/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.chronos.Group;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.Shot;
import io.intino.sumus.chronos.ShotCollector;
import io.intino.sumus.chronos.State;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReelFile {
    private final File file;
    private final Header header;
    private final Instant from;

    private ReelFile(File file, Header header) {
        this.file = file;
        this.header = header;
        this.from = this.readFirstInstantFrom(file);
    }

    public static ReelFile open(File file) throws IOException {
        return new ReelFile(file, Header.read(file));
    }

    public static ReelFile create(File file) throws IOException {
        return new ReelFile(file, Header.create(file));
    }

    public File file() {
        return this.file;
    }

    public Set<String> signals() {
        return this.header.signals();
    }

    public Set<String> signals(State state) {
        if (state == State.On) {
            return this.header.onSignals();
        }
        HashSet<String> signals = new HashSet<String>(this.signals());
        signals.removeAll(this.header.onSignals());
        return signals;
    }

    public List<Group> groups() {
        return this.header.groups.subList(1, this.header.groups.size());
    }

    public Group group(String name) {
        return this.header.group(name);
    }

    public State lastStateOf(String signal) {
        return this.header.stateOf(signal);
    }

    public Instant lastUpdateOf(String signal) {
        return this.header.instantOf(signal);
    }

    public Shot lastShotOf(String signal) {
        return this.signals().contains(signal) ? new Shot(this.lastUpdateOf(signal), this.lastStateOf(signal), signal) : null;
    }

    public List<Shot> lastShots() {
        return this.signals().stream().map(this::lastShotOf).collect(Collectors.toList());
    }

    public List<Shot> lastShots(String group) {
        return this.header.exists(group) ? this.lastShots(this.header.group(group)) : Collections.emptyList();
    }

    public List<Shot> lastShots(Group group) {
        return group.signals.stream().map(this::lastShotOf).collect(Collectors.toList());
    }

    public Session session() {
        return new Session();
    }

    public Instant start() {
        return this.from;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Shot shot) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeLong(shot.ts.toEpochMilli());
                dos.writeByte(shot.state == State.On ? 1 : 0);
                dos.writeInt(shot.signal.hashCode());
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReelReader reel(Instant from, Instant to) {
        return new ReelReader(from, to);
    }

    public ReelReader reel(Instant to) {
        return new ReelReader(this.from, to);
    }

    public ReelReader reel() {
        return new ReelReader(this.from, Instant.now());
    }

    private Instant readFirstInstantFrom(File file) {
        Instant instant;
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            is.skip(8192L);
            long epoch = is.readLong();
            instant = Instant.ofEpochMilli(epoch);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Instant.now();
            }
        }
        is.close();
        return instant;
    }

    private static class Header {
        private static final int SIZE = 8192;
        private static final String EndOfDictionary = "\u001c";
        private final Map<Integer, String> dictionary;
        private final Map<String, Instant> signals;
        private final List<Group> groups;
        private final Group baseGroup;

        public Header(List<Group> groups, Map<String, Instant> signals, Map<Integer, String> dictionary) {
            this.dictionary = dictionary;
            this.signals = signals;
            this.groups = new ArrayList<Group>(groups);
            this.baseGroup = groups.get(0);
        }

        public Set<String> signals() {
            return this.signals.keySet();
        }

        public Set<String> onSignals() {
            return this.baseGroup.signals;
        }

        public State stateOf(String signal) {
            return this.baseGroup.contains(signal) ? State.On : State.Off;
        }

        public Instant instantOf(String signal) {
            return this.signals.get(signal);
        }

        public void set(String signal, State state) {
            if (state == State.On) {
                this.baseGroup.put(signal);
            } else {
                this.baseGroup.remove(signal);
            }
        }

        public void set(String signal, Instant ts) {
            this.signals.put(signal, ts);
        }

        public void add(Group group) {
            if (this.exists(group)) {
                return;
            }
            this.groups.add(group);
        }

        private boolean exists(String group) {
            return this.groups.stream().anyMatch(g -> g.name.equals(group));
        }

        private boolean exists(Group group) {
            return this.groups.stream().anyMatch(g -> g.equals((Object)group));
        }

        private Group group(String name) {
            return this.groups.stream().filter(g -> g.name.equals(name)).findFirst().orElse(null);
        }

        public Group create(String name) {
            Group group = this.group(name);
            if (group == null) {
                group = new Group(name);
                this.groups.add(group);
            }
            return group;
        }

        public static Header create(File file) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.write(new byte[8192]);
            }
            return new Header(List.of(new Group("~")), new HashMap<String, Instant>(), new HashMap<Integer, String>());
        }

        public static Header read(File file) {
            Header header;
            DataInputStream is = new DataInputStream(new FileInputStream(file));
            try {
                Map<Integer, String> dictionary = Header.readDictionary(is);
                Map<String, Instant> signals = Header.readSignals(is, dictionary);
                List<Group> groups = Header.readGroups(is, dictionary);
                header = new Header(groups, signals, dictionary);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
            return header;
        }

        private static Map<Integer, String> readDictionary(DataInputStream is) throws IOException {
            String label;
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            while (!(label = is.readUTF()).equals(EndOfDictionary)) {
                result.put(label.hashCode(), label);
            }
            return result;
        }

        private static Map<String, Instant> readSignals(DataInputStream is, Map<Integer, String> dictionary) throws IOException {
            int id;
            HashMap<String, Instant> result = new HashMap<String, Instant>();
            while ((id = is.readInt()) != 0) {
                result.put(dictionary.get(id), Instant.ofEpochMilli(is.readLong()));
            }
            return result;
        }

        private static List<Group> readGroups(DataInputStream is, Map<Integer, String> dictionary) throws IOException {
            int id;
            ArrayList<Group> list = new ArrayList<Group>();
            while ((id = is.readInt()) != 0) {
                Group group = Header.read(dictionary.get(id), is, dictionary);
                list.add(group);
            }
            return list;
        }

        private static Group read(String name, DataInputStream is, Map<Integer, String> dictionary) throws IOException {
            int signal;
            HashSet<String> set = new HashSet<String>();
            while ((signal = is.readInt()) != 0) {
                set.add(dictionary.get(signal));
            }
            return new Group(name, set);
        }

        public void write(File file) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.seek(0L);
                this.writeDictionary(raf);
                this.writeSignals(raf);
                this.writeGroups(raf);
            }
        }

        private void writeDictionary(RandomAccessFile raf) throws IOException {
            this.updateDictionary();
            for (String word : this.dictionary.values()) {
                raf.writeUTF(word);
            }
            raf.writeUTF(EndOfDictionary);
        }

        private void updateDictionary() {
            for (Group group : this.groups) {
                this.put(group.name);
            }
            for (String signal : this.signals.keySet()) {
                this.put(signal);
            }
        }

        private void writeSignals(RandomAccessFile raf) throws IOException {
            for (String signal : this.signals.keySet()) {
                raf.writeInt(signal.hashCode());
                raf.writeLong(this.signals.get(signal).toEpochMilli());
            }
            raf.writeInt(0);
        }

        private void put(String name) {
            if (this.dictionary.containsKey(name.hashCode())) {
                return;
            }
            this.dictionary.put(name.hashCode(), name);
        }

        private void writeGroups(RandomAccessFile raf) throws IOException {
            for (Group group : this.groups) {
                Header.writeGroup(raf, group);
            }
            raf.writeInt(0);
        }

        private static void writeGroup(RandomAccessFile raf, Group group) throws IOException {
            raf.writeInt(group.name.hashCode());
            for (String signal : group.signals) {
                raf.writeInt(signal.hashCode());
            }
            raf.writeInt(0);
        }

        public List<Group> groups() {
            return this.groups;
        }

        public List<Shot> shotsToTurnOn(Instant now, Set<String> signals) {
            return signals.stream().filter(s -> !s.isEmpty() && this.stateOf((String)s) == State.Off).map(s -> Shot.on(now, s)).collect(Collectors.toList());
        }

        public List<Shot> shotsToTurnOff(Instant instant, Set<String> signals) {
            return signals.stream().filter(s -> !s.isEmpty() && this.stateOf((String)s) == State.On).map(s -> Shot.off(instant, s)).collect(Collectors.toList());
        }

        private String get(int signal) {
            return this.dictionary.get(signal);
        }
    }

    public class Reader {
        protected final Instant from;
        protected final Instant to;

        public Reader(Instant from, Instant to) {
            this.from = from;
            this.to = to;
        }

        protected void execute(ShotCollector shotCollector) {
            try {
                DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(ReelFile.this.file)));
                try {
                    is.skipBytes(8192);
                    while (true) {
                        long epoch = is.readLong();
                        byte state = is.readByte();
                        int signal = is.readInt();
                        shotCollector.add(new Shot(Instant.ofEpochMilli(epoch), State.of(state == 1), ReelFile.this.header.get(signal)));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public class ReelReader
    extends Reader {
        public ReelReader(Instant from, Instant to) {
            super(from, to);
        }

        public Reel by(Period period) {
            Reel.ReelBuilder builder = new Reel.ReelBuilder(this.from, this.to, ReelFile.this.header.groups()).by(period);
            this.execute(builder);
            return builder.close();
        }
    }

    public class Session
    implements AutoCloseable {
        private BufferedOutputStream output;

        public Session() {
            try {
                this.output = new BufferedOutputStream(new FileOutputStream(ReelFile.this.file, true));
            }
            catch (FileNotFoundException e) {
                Logger.error(e);
            }
        }

        public File file() {
            return ReelFile.this.file;
        }

        public Session set(Instant instant, String group, String ... signals) throws IOException {
            return this.set(instant, ReelFile.this.header.create(group), signals);
        }

        public Session set(Instant instant, Group group, String ... signals) throws IOException {
            ArrayList<Shot> shots = new ArrayList<Shot>();
            shots.addAll(ReelFile.this.header.shotsToTurnOff(instant, group.signalsThatAreNotIn(signals)));
            shots.addAll(ReelFile.this.header.shotsToTurnOn(instant, Set.of(signals)));
            return this.append(group, shots);
        }

        public Session append(String group, Shot ... shots) throws IOException {
            return this.append(group, List.of(shots));
        }

        public Session append(String group, List<Shot> shots) throws IOException {
            return this.append(ReelFile.this.header.create(group), shots);
        }

        private Session append(Group group, List<Shot> shots) throws IOException {
            ReelFile.this.header.add(group);
            for (Shot shot : shots) {
                if (ReelFile.this.header.stateOf(shot.signal) == shot.state) continue;
                this.output.write(ReelFile.this.serialize(shot));
                ReelFile.this.header.set(shot.signal, shot.state);
                ReelFile.this.header.set(shot.signal, shot.ts);
                group.put(shot.signal);
            }
            return this;
        }

        @Override
        public void close() throws IOException {
            this.output.flush();
            this.output.close();
            ReelFile.this.header.write(ReelFile.this.file);
        }
    }
}

