/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Group {
    public final String name;
    public final Set<String> signals;

    public Group(String name) {
        this(name, new HashSet<String>());
    }

    public Group(String name, Set<String> signals) {
        this.name = name;
        this.signals = signals;
    }

    public boolean contains(String signal) {
        return this.signals.contains(signal);
    }

    public void put(String signal) {
        this.signals.add(signal);
    }

    public void remove(String signal) {
        this.signals.remove(signal);
    }

    public Set<String> signalsThatAreNotIn(String[] signals) {
        HashSet<String> result = new HashSet<String>(this.signals);
        result.removeAll(Set.of(signals));
        return result;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && (this == o || this.equals((Group)o));
    }

    private boolean equals(Group group) {
        return Objects.equals(this.name, group.name) && Objects.equals(this.signals, group.signals);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.signals);
    }

    public String toString() {
        return this.name + "-" + this.signals.size();
    }
}

