/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.ness.master.Datamart;
import java.util.List;

public class PlaceMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;
    private boolean useListeners = true;

    public PlaceMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public PlaceMounter useListeners(boolean useListeners) {
        this.useListeners = useListeners;
        return this;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip && this.useListeners) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled")) continue;
            if (message.get("enabled").asBoolean().booleanValue()) {
                this.entities.enable(owner.id());
                continue;
            }
            this.entities.disable(owner.id());
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(Place.definition, id);
        if (entity == null) {
            entity = this.entities.getDisabled(Place.definition, id);
        }
        if (entity == null) {
            entity = new Place(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    new Thread(() -> listener.onCreate(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Update: {
                    new Thread(() -> listener.onUpdate(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Remove: {
                    new Thread(() -> listener.onRemove(entity), "MasterListener-PlaceMounter-" + System.currentTimeMillis()).start();
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "label": {
                return this.parseLabel(message);
            }
            case "coordinates": {
                return this.parseCoordinates(message);
            }
            case "timeOffset": {
                return this.parseTimeOffset(message);
            }
            case "region": {
                return this.parseRegion(message);
            }
            case "city": {
                return this.parseCity(message);
            }
            case "area": {
                return this.parseArea(message);
            }
            case "address": {
                return this.parseAddress(message);
            }
            case "postalCode": {
                return this.parsePostalCode(message);
            }
        }
        return message.get(attribute).asString();
    }

    private String parseLabel(Message m) {
        return m.get("label").as(String.class);
    }

    private String parseCoordinates(Message m) {
        return m.get("coordinates").as(String.class);
    }

    private Integer parseTimeOffset(Message m) {
        return m.get("timeOffset").as(Integer.class);
    }

    private String parseRegion(Message m) {
        return m.get("region").as(String.class);
    }

    private String parseCity(Message m) {
        return m.get("city").as(String.class);
    }

    private String parseArea(Message m) {
        return m.get("area").asString();
    }

    private String parseAddress(Message m) {
        return m.get("address").as(String.class);
    }

    private String parsePostalCode(Message m) {
        return m.get("postalCode").as(String.class);
    }
}

