/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.framework;

import io.intino.consul.terminal.Terminal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface Activity {
    public String id();

    public Result configure(Context var1, Store var2);

    public Map<String, String> currentConfiguration();

    public Result onStart();

    public Result onStop();

    public static interface Store {
        public static final String Separator = "#";

        public void put(String var1, Object var2);

        public <T> T get(String var1, Class<T> var2);

        public <T> T get(String var1, Type var2);

        public Stream<String> keys();

        public File workingDirectory();

        public void remove(String var1);
    }

    public static interface System {
        public String name();

        public OperatingSystem operatingSystem() throws Exception;

        public HDD hdd();

        public RAM ram();

        public CPU cpu();

        public Network network();

        public static interface FileSystem {
            public boolean exists(String var1);

            public String readFile(String var1);

            public byte[] readFileBytes(String var1);

            public InputStream openFile(String var1);

            public void writeString(String var1, String var2);

            public void writeString(String var1, String var2, StandardOpenOption ... var3);

            public void changeOwner(String var1, String var2, String var3);

            public void changePermissions(String var1, String var2);

            public void copy(String var1, String var2, CopyOption ... var3);

            public void mkdirs(String var1);

            public void delete(String var1);

            public void deleteDirectory(String var1);

            public List<String> listDirectory(String var1);
        }

        public static interface ProcessRunner {
            default public String execute(String ... command) throws Exception {
                return this.execute(List.of(command), 180);
            }

            default public String execute(List<String> command) throws Exception {
                return this.execute(command, 180);
            }

            public String execute(List<String> var1, int var2) throws Exception;
        }

        public static interface OSProcess {
            public String name();

            public String path();

            public String commandLine();

            public List<String> arguments();

            public String user();

            public String group();

            public State state();

            public boolean isOSProcess();

            public boolean isSystemService();

            public String systemServiceName();

            public int processID();

            public int parentProcessID();

            public int threadCount();

            public long virtualSize();

            public long residentSetSize();

            public long kernelTime();

            public long userTime();

            public long upTime();

            public long startTime();

            public long bytesRead();

            public long bytesWritten();

            public long openFiles();

            public long openFilesLimit();

            public double processCpuLoadCumulative();

            public int getBitness();

            public static enum State {
                NEW,
                RUNNING,
                SLEEPING,
                WAITING,
                ZOMBIE,
                STOPPED,
                OTHER,
                INVALID,
                SUSPENDED;

            }
        }

        public static interface Measurements {
            public long usageRAM();

            public long usageHDD();

            public double usageCPU();

            public double usageSystem();

            public int usageFiles();

            public long usageThreads();

            public long dataReceived();

            public long dataSent();

            public double temperatureKernel();

            public double temperatureExternal();
        }

        public static interface OperatingSystem {
            public String name();

            public String fullName();

            public long bootTimeSeconds();

            public long userHz();

            public long pageSize();

            public Measurements measurements();

            public FileSystem fileSystem() throws IOException;

            public ProcessRunner processRunner() throws Exception;

            public int createConnection(int var1);

            public void removeConnection(int var1);

            public List<? extends OSProcess> processes() throws Exception;

            public int processCount();

            public static enum Name {
                Windows,
                Mac,
                Unix;

            }
        }

        public record Network(String localIP, String publicIP, String ISP) {
        }

        public record CPU(int cores, long usagePercent, double temperature) {
        }

        public record RAM(long capacityMB, long usedMB) {
        }

        public record HDD(long capacityMB, long usedMB, long maxOpenFiles) {
        }
    }

    public record Result(boolean success, String remarks) {
    }

    public record Context(Terminal terminal, System system, String hostName, String observer, String ss, Map<String, String> initialConfiguration) {
    }
}

