/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class UploadFileRequest
extends ContainerRequest {
    public static final String ID = "uploadFile";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        BytesMessage message = (BytesMessage)request;
        try {
            String filename = this.parameter(request, "filename");
            byte[] payload = new byte[(int)message.getBodyLength()];
            message.readBytes(payload);
            String home = System.getProperty("user.home");
            File destination = new File(home, "Downloads" + File.separator + filename);
            destination.getParentFile().mkdirs();
            Files.write(destination.toPath(), payload, new OpenOption[0]);
            return new RequestAttendant.RequestResult(true, "File uploaded");
        }
        catch (Throwable e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }
}

