/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal.remotedatalake;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.intino.alexandria.jms.JmsProducer;
import io.intino.alexandria.jms.QueueProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.JmsConnector;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class DatalakeAccessor {
    public static final String PATH = "service.ness.datalake";
    private final JmsConnector connector;
    private final Session session;

    DatalakeAccessor(JmsConnector connector) {
        this.connector = connector;
        this.session = connector.session();
    }

    public MessageConsumer queryWithConsumer(String query) {
        Session session = this.connector.session();
        try {
            TemporaryQueue temporaryQueue = session.createTemporaryQueue();
            MessageConsumer consumer = session.createConsumer(temporaryQueue);
            this.sendRequest(query, temporaryQueue);
            return consumer;
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    public Message query(String query) {
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        Session session = this.connector.session();
        try {
            TemporaryQueue temporaryQueue = session.createTemporaryQueue();
            MessageConsumer consumer = session.createConsumer(temporaryQueue);
            Object monitor = new Object();
            consumer.setMessageListener(m -> {
                response.set(m);
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            });
            this.sendRequest(query, temporaryQueue);
            DatalakeAccessor.waitForResponse(monitor);
            consumer.close();
            return response.get();
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForResponse(Object monitor) {
        try {
            Object object = monitor;
            synchronized (object) {
                monitor.wait(30000L);
            }
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    private void sendMessage(JmsProducer producer, Message message, int expirationTimeInSeconds) {
        try {
            Thread thread = new Thread(() -> producer.produce(message, expirationTimeInSeconds));
            thread.start();
            thread.join(1000L);
            thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendRequest(String query, TemporaryQueue temporaryQueue) throws JMSException {
        QueueProducer producer = new QueueProducer(this.session, PATH);
        TextMessage txtMessage = this.session.createTextMessage();
        txtMessage.setText(query);
        txtMessage.setJMSReplyTo(temporaryQueue);
        txtMessage.setJMSCorrelationID(JmsConnector.createRandomString());
        this.sendMessage(producer, txtMessage, 100);
        producer.close();
    }

    public static JsonObject reflowSchema(String tank, String source, List<String> tubs) {
        JsonArray tubsArray = new JsonArray();
        tubs.forEach(tubsArray::add);
        return DatalakeAccessor.reflowSchema(tank, source, tubsArray);
    }

    public static JsonObject reflowSchema(String tank, String source, JsonArray tubs) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("operation", "reflow");
        jsonObject.addProperty("tank", tank);
        jsonObject.addProperty("source", source);
        jsonObject.add("tubs", tubs);
        return jsonObject;
    }
}

