package io.intino.consul.container.model;

import java.util.StringJoiner;

import static java.lang.String.valueOf;

public record Info(String name, java.util.List<String> localIps, String publicIp, int cores, long diskSize,
				   long memorySize,
				   long maxOpenFiles, String jvm,
				   String os) {

	@Override
	public String toString() {
		return new StringJoiner("\t")
				.add(String.join(";", localIps))
				.add(publicIp)
				.add(valueOf(cores))
				.add(valueOf(diskSize))
				.add(valueOf(memorySize))
				.add(valueOf(maxOpenFiles))
				.add(valueOf(jvm))
				.add(valueOf(os))
				.toString();
	}
}
