package io.intino.consul.container.box.service.requests;

import io.intino.consul.container.box.ContainerBox;
import jakarta.jms.Message;

import java.util.Map;

public class ActivitiesRequest extends ContainerRequest {
	public static final String ID = "activities";
	private final ContainerBox box;

	public ActivitiesRequest(ContainerBox box) {
		this.box = box;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		Map<String, Boolean> activities = box.activities().activities();
		return new RequestResult(true, activities.entrySet().stream().map(e -> new Activity(e.getKey(), nameOf(e.getKey()), e.getValue())).toList());
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}

	private String nameOf(String key) {
		return key.split(":")[1];
	}

	public record Activity(String id, String name, boolean enabled) {
	}
}
