package io.intino.consul.container.box.schemas;

import io.intino.consul.container.box.schemas.*;

public class Parameter implements java.io.Serializable {

	private String name;
	private Boolean isRequired = false;
	private Type type;

	public enum Type {
		tsv, string, schema
	}

	private String description;
	private java.util.List<String> tsvColumns = new java.util.ArrayList<>();
	private java.util.List<String> tsvEditableColumns = new java.util.ArrayList<>();

	public String name() {
		return this.name;
	}

	public Boolean isRequired() {
		return this.isRequired;
	}

	public Type type() {
		return type;
	}

	public String description() {
		return this.description;
	}

	public java.util.List<String> tsvColumns() {
		return this.tsvColumns;
	}

	public java.util.List<String> tsvEditableColumns() {
		return this.tsvEditableColumns;
	}

	public Parameter name(String name) {
		this.name = name;
		return this;
	}

	public Parameter isRequired(Boolean isRequired) {
		this.isRequired = isRequired;
		return this;
	}

	public Parameter type(Type type) {
		this.type = type;
		return this;
	}

	public Parameter description(String description) {
		this.description = description;
		return this;
	}

	public Parameter tsvColumns(java.util.List<String> tsvColumns) {
		this.tsvColumns = tsvColumns;
		return this;
	}

	public Parameter tsvEditableColumns(java.util.List<String> tsvEditableColumns) {
		this.tsvEditableColumns = tsvEditableColumns;
		return this;
	}
}