package io.intino.consul.container.box;

import java.util.Map;
import java.util.HashMap;
import java.io.File;

public class ContainerConfiguration extends io.intino.alexandria.core.BoxConfiguration {

	public ContainerConfiguration(String[] args) {
		super(args);
	}

	public String unit() {
		return get("unit");
	}

	public String datahubUrl() {
		return get("datahub_url");
	}

	public String datahubUser() {
		return get("datahub_user");
	}

	public String datahubPassword() {
		return get("datahub_password");
	}

	public File keyStoreFile() {
		return get("key_store_file") == null ? null : new File(get("key_store_file"));
	}

	public String keyStorePassword() {
		return get("key_store_password");
	}

	public File trustStoreFile() {
		return get("trust_store_file") == null ? null : new File(get("trust_store_file"));
	}

	public String trustStorePassword() {
		return get("trust_store_password");
	}

	public String ispProviderToken() {
		return get("isp_provider_token");
	}

	public String store() {
		return get("store");
	}

	public String remoteServer() {
		return get("remote-server");
	}

	public String remotePort() {
		return get("remote-port");
	}

	public String remoteUser() {
		return get("remote-user");
	}

	public String privateKey() {
		return get("private-key");
	}

	public java.io.File home() {
		return new java.io.File(args.getOrDefault("home", System.getProperty("user.home")));
	}
}