/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.type.MeanSlopePair;

public class PlaaEuclideanDistance
implements GenericDistanceMeasure<MeanSlopePair[]> {
    private static final long serialVersionUID = -2987558975696360228L;

    @Override
    public double compute(MeanSlopePair[] a, MeanSlopePair[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(MeanSlopePair[] a, MeanSlopePair[] b, double cutoff) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        int w = a.length;
        double k = 1.0 / (double)w;
        double transformedCutoff = cutoff * cutoff;
        for (int i = 0; i < w; ++i) {
            double aux = a[i].getMean() - b[i].getMean();
            double currentDistance = (sum1 += aux * aux) * k + (sum2 += (aux = a[i].getSlope() - b[i].getSlope()) * aux) * (k * k - 1.0) / 18.0;
            if (!(currentDistance >= transformedCutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        sum2 = sum2 * (k * k - 1.0) / 18.0;
        return FastMath.sqrt((sum1 *= k) + sum2);
    }
}

