/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.LongStream;

public class Period {
    public static Period Seconds = Period.each(1, ChronoUnit.SECONDS);
    public static Period Minutes = Period.each(1, ChronoUnit.MINUTES);
    public static Period Hours = Period.each(1, ChronoUnit.HOURS);
    public static Period Days = Period.each(1, ChronoUnit.DAYS);
    public static Period Weeks = Period.eachWeek(DayOfWeek.MONDAY);
    public static Period Months = Period.each(1, ChronoUnit.MONTHS);
    public static Period Quarters = Period.each(3, ChronoUnit.MONTHS);
    public static Period HalfYears = Period.each(6, ChronoUnit.MONTHS);
    public static Period Years = Period.each(1, ChronoUnit.YEARS);
    public final int amount;
    public final ChronoUnit unit;
    private static Map<String, ChronoUnit> Units = Period.units();
    private static final Map<Long, Integer> LabelLengths = Map.of(Years.duration(), 4, Months.duration(), 6, Days.duration(), 8, Hours.duration(), 10, Minutes.duration(), 12);

    public static Period each(int amount, ChronoUnit unit) {
        return new Period(amount, unit);
    }

    public static Period each(short amount, short chronoUnit) {
        return new Period(amount, ChronoUnit.values()[chronoUnit]);
    }

    public static Period each(String data) {
        return Period.parse(data.toUpperCase().toCharArray());
    }

    public static WeekPeriod eachWeek(DayOfWeek firstDayOfWeek) {
        return new WeekPeriod(1, firstDayOfWeek);
    }

    public Period(int amount, ChronoUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public int length(Instant from, Instant to) {
        return this.length(this.iterator(from), to.getEpochSecond());
    }

    private int length(Iterator<Instant> iterator, long to) {
        return (int)LongStream.iterate(Period.nextIn(iterator), next -> next < to, next -> Period.nextIn(iterator)).count();
    }

    private static long nextIn(Iterator<Instant> iterator) {
        return iterator.next().getEpochSecond();
    }

    public Instant crop(String instant) {
        return this.crop(Instant.parse(instant));
    }

    public Instant crop(Instant instant) {
        switch (this.unit) {
            case YEARS: {
                return this.cropYear(this.split(instant));
            }
            case MONTHS: {
                return this.cropMonth(this.split(instant));
            }
            case WEEKS: 
            case DAYS: {
                return this.cropDay(this.split(instant));
            }
        }
        return this.crop(instant.getEpochSecond());
    }

    private Instant cropYear(int[] split) {
        return Period.toInstant(LocalDate.of(split[0], 1, 1));
    }

    private Instant cropMonth(int[] split) {
        return Period.toInstant(LocalDate.of(split[0], this.cropMonth(split[1]), 1));
    }

    private int cropMonth(int month) {
        return month - 1 - (month - 1) % this.amount + 1;
    }

    private Instant cropWeek(int[] split) {
        return Period.toInstant(LocalDate.of(split[0], split[1], split[2]));
    }

    private Instant cropDay(int[] split) {
        return Period.toInstant(LocalDate.of(split[0], split[1], split[2]));
    }

    private static Instant toInstant(LocalDate date) {
        return date.atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    }

    private int[] split(Instant instant) {
        String str = instant.toString();
        return new int[]{Integer.parseInt(str.substring(0, 4)), Integer.parseInt(str.substring(5, 7)), Integer.parseInt(str.substring(8, 10))};
    }

    private Instant crop(long epochSecond) {
        return Instant.ofEpochSecond(epochSecond - epochSecond % this.duration());
    }

    private static Period parse(char[] chars) {
        int amount = Period.amountIn(chars);
        ChronoUnit unit = Units.getOrDefault(Period.unitIn(chars), ChronoUnit.DAYS);
        return new Period(amount, unit);
    }

    private static String unitIn(char[] chars) {
        StringBuilder unit = new StringBuilder();
        for (char c : chars) {
            if (c < 'A' || c > 'Z') continue;
            unit.append(c);
        }
        String s = unit.toString();
        return s.endsWith("S") ? Period.singular(s) : s;
    }

    private static int amountIn(char[] chars) {
        int amount = 0;
        for (char c : chars) {
            if (c < '0' || c > '9') break;
            amount = amount * 10 + (c - 48);
        }
        return amount == 0 ? 1 : amount;
    }

    public String toString() {
        return this.amount + " " + this.toString(this.unit.toString().toLowerCase());
    }

    private String toString(String unit) {
        return this.amount == 1 ? Period.singular(unit) : unit;
    }

    private static String singular(String unit) {
        return unit.substring(0, unit.length() - 1);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((Period)o);
    }

    private boolean equals(Period period) {
        return this.amount == period.amount && this.unit == period.unit;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.unit);
    }

    public Iterator<Instant> iterator(Instant from) {
        switch (this.unit) {
            case WEEKS: {
                return new WeekIterator(from);
            }
            case MONTHS: {
                return new MonthIterator(from);
            }
            case YEARS: {
                return new YearIterator(from);
            }
        }
        return new DefaultIterator(from);
    }

    public String labelOf(Instant instant) {
        return this.trim(this.crop(instant).toString());
    }

    private String trim(String str) {
        return this.clean(str).substring(0, this.labelLength(this.duration()));
    }

    private String clean(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private int labelLength(long duration) {
        return LabelLengths.keySet().stream().sorted((a, b) -> Long.compare(b, a)).filter(d -> duration >= d).mapToInt(LabelLengths::get).findFirst().orElse(14);
    }

    public Instant next(Instant instant) {
        Iterator<Instant> iterator = this.iterator(instant);
        iterator.next();
        return iterator.next();
    }

    public long duration() {
        return (long)this.amount * this.unit.getDuration().toSeconds();
    }

    private static Map<String, ChronoUnit> units() {
        return Map.of("SECOND", ChronoUnit.SECONDS, "MINUTE", ChronoUnit.MINUTES, "HOUR", ChronoUnit.HOURS, "DAY", ChronoUnit.DAYS, "WEEK", ChronoUnit.WEEKS, "MONTH", ChronoUnit.MONTHS, "YEAR", ChronoUnit.YEARS);
    }

    public static class WeekPeriod
    extends Period {
        private final DayOfWeek firstDayOfWeek;

        public WeekPeriod(int amount, DayOfWeek firstDayOfWeek) {
            super(amount, ChronoUnit.WEEKS);
            this.firstDayOfWeek = firstDayOfWeek;
        }

        @Override
        public Iterator<Instant> iterator(Instant from) {
            return new WeekIterator(this.firstDayOfWeek(from));
        }

        private Instant firstDayOfWeek(Instant instant) {
            Instant next = WeekPeriod.dailyIterator(instant).next().plus(-6L, ChronoUnit.DAYS);
            while (WeekPeriod.dayOfWeek(next) != this.firstDayOfWeek) {
                next = next.plus(1L, ChronoUnit.DAYS);
            }
            return next;
        }

        private static Iterator<Instant> dailyIterator(Instant instant) {
            return Days.iterator(instant);
        }

        private static DayOfWeek dayOfWeek(Instant instant) {
            return instant.atZone(ZoneOffset.UTC).getDayOfWeek();
        }
    }

    private class YearIterator
    implements Iterator<Instant> {
        private LocalDate next;

        private YearIterator(Instant instant) {
            this.next = LocalDate.ofInstant(Period.this.crop(instant), ZoneOffset.UTC);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Instant next() {
            Instant result = this.next.atStartOfDay().toInstant(ZoneOffset.UTC);
            this.next = this.next.plusYears(Period.this.amount);
            return result;
        }
    }

    private class MonthIterator
    implements Iterator<Instant> {
        private LocalDate next;

        private MonthIterator(Instant instant) {
            this.next = LocalDate.ofInstant(Period.this.crop(instant), ZoneOffset.UTC);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Instant next() {
            Instant result = this.next.atStartOfDay().toInstant(ZoneOffset.UTC);
            this.next = this.next.plusMonths(Period.this.amount);
            return result;
        }
    }

    private class WeekIterator
    implements Iterator<Instant> {
        private Instant next;

        private WeekIterator(Instant instant) {
            this.next = Period.this.crop(instant);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Instant next() {
            Instant result = this.next;
            this.next = this.next.plusSeconds(Period.this.duration());
            return result;
        }
    }

    private class DefaultIterator
    implements Iterator<Instant> {
        private final long time;
        private long next;

        private DefaultIterator(Instant instant) {
            this.time = Period.this.duration();
            this.next = Period.this.crop(instant).getEpochSecond();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Instant next() {
            Instant result = Instant.ofEpochSecond(this.next);
            this.next += this.time;
            return result;
        }
    }
}

