/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.reflection;

import io.intino.ness.master.Datamart;
import io.intino.ness.master.reflection.ConceptDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface DatamartDefinition {
    public String name();

    public Datamart.Scale scale();

    default public List<ConceptDefinition<?>> concepts() {
        ArrayList concepts = new ArrayList(this.entities());
        concepts.addAll(this.structs());
        return concepts;
    }

    public Query<EntityDefinition> entities();

    public Query<StructDefinition> structs();

    default public Optional<ConceptDefinition<?>> concept(String name) {
        return this.concepts().stream().filter(e -> e.name().equals(name)).findFirst();
    }

    default public Optional<EntityDefinition> entity(String name) {
        return this.entities().stream().filter(e -> e.name().equals(name)).findFirst();
    }

    default public Optional<StructDefinition> struct(String name) {
        return this.structs().stream().filter(e -> e.name().equals(name)).findFirst();
    }

    public static class Query<T extends ConceptDefinition<T>>
    extends AbstractList<T> {
        private final List<T> source;

        public Query(List<T> source) {
            this.source = source;
        }

        public Query<T> instanceOf(T ancestor) {
            return new Query(this.source.stream().filter(arg_0 -> ancestor.isAncestorOf(arg_0)).collect(Collectors.toList()));
        }

        @Override
        public Query<T> of(T definition) {
            return new Query(this.source.stream().filter((Predicate<ConceptDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/intino/ness/master/reflection/ConceptDefinition;)Z)(definition)).collect(Collectors.toList()));
        }

        @Override
        public T get(int index) {
            return (T)((ConceptDefinition)this.source.get(index));
        }

        @Override
        public int size() {
            return this.source.size();
        }
    }
}

