/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.HardwareAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class ComputerAssertion
extends HardwareAssertion
implements Serializable {
    public ComputerAssertion(String ss, String id) {
        this(new MessageEvent("ComputerAssertion", ss).toMessage(), id);
    }

    public ComputerAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ComputerAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ComputerAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ComputerAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ComputerAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public ComputerAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static ComputerAssertion fromString(String event) {
        return new ComputerAssertion(new MessageReader(event).next());
    }

    public String architecture() {
        return !this.message.contains("architecture") ? null : this.message.get("architecture").asString();
    }

    public String os() {
        return !this.message.contains("os") ? null : this.message.get("os").asString();
    }

    public Integer cores() {
        return this.message.get("cores").asInteger();
    }

    public Long diskSize() {
        return this.message.get("diskSize").asLong();
    }

    public Long memorySize() {
        return this.message.get("memorySize").asLong();
    }

    public Long maxOpenFiles() {
        return this.message.get("maxOpenFiles").asLong();
    }

    public String jvm() {
        return !this.message.contains("jvm") ? null : this.message.get("jvm").asString();
    }

    public String isp() {
        return !this.message.contains("isp") ? null : this.message.get("isp").asString();
    }

    public ComputerAssertion architecture(String architecture) {
        if (architecture == null) {
            this.message.remove("architecture");
        } else {
            this.message.set("architecture", architecture);
        }
        return this;
    }

    public ComputerAssertion os(String os) {
        if (os == null) {
            this.message.remove("os");
        } else {
            this.message.set("os", os);
        }
        return this;
    }

    public ComputerAssertion cores(Integer cores) {
        this.message.set("cores", cores);
        return this;
    }

    public ComputerAssertion diskSize(Long diskSize) {
        if (diskSize == null) {
            this.message.remove("diskSize");
        } else {
            this.message.set("diskSize", diskSize);
        }
        return this;
    }

    public ComputerAssertion memorySize(Long memorySize) {
        if (memorySize == null) {
            this.message.remove("memorySize");
        } else {
            this.message.set("memorySize", memorySize);
        }
        return this;
    }

    public ComputerAssertion maxOpenFiles(Long maxOpenFiles) {
        if (maxOpenFiles == null) {
            this.message.remove("maxOpenFiles");
        } else {
            this.message.set("maxOpenFiles", maxOpenFiles);
        }
        return this;
    }

    public ComputerAssertion jvm(String jvm) {
        if (jvm == null) {
            this.message.remove("jvm");
        } else {
            this.message.set("jvm", jvm);
        }
        return this;
    }

    public ComputerAssertion isp(String isp) {
        if (isp == null) {
            this.message.remove("isp");
        } else {
            this.message.set("isp", isp);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

