/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.SoftwareAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ApplicationAssertion
extends SoftwareAssertion
implements Serializable {
    public ApplicationAssertion(String ss, String id) {
        this(new MessageEvent("ApplicationAssertion", ss).toMessage(), id);
    }

    public ApplicationAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ApplicationAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ApplicationAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ApplicationAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ApplicationAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public ApplicationAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static ApplicationAssertion fromString(String event) {
        return new ApplicationAssertion(new MessageReader(event).next());
    }

    public String name() {
        return !this.message.contains("name") ? null : this.message.get("name").asString();
    }

    public String systemService() {
        return !this.message.contains("systemService") ? null : this.message.get("systemService").asString();
    }

    public String user() {
        return !this.message.contains("user") ? null : this.message.get("user").asString();
    }

    public Instant startingTime() {
        return !this.message.contains("startingTime") ? null : this.message.get("startingTime").asInstant();
    }

    public List<Integer> pids() {
        return new ArrayList<Integer>(this.message.contains("pids") ? Arrays.asList(this.message.get("pids").as(Integer[].class)) : Collections.emptyList()){

            @Override
            public boolean add(Integer value) {
                super.add(value);
                ApplicationAssertion.this.message.append("pids", value);
                return true;
            }

            @Override
            public void add(int index, Integer element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof Integer)) {
                    return false;
                }
                super.remove(value);
                ApplicationAssertion.this.message.remove("pids", value);
                return true;
            }

            @Override
            public Integer remove(int index) {
                Integer type = (Integer)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Integer> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Integer)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Integer> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Integer> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ApplicationAssertion.this.message.remove("pids");
            }
        };
    }

    public String commandLine() {
        return !this.message.contains("commandLine") ? null : this.message.get("commandLine").asString();
    }

    public State state() {
        return !this.message.contains("state") ? null : State.valueOf(this.message.get("state").asString());
    }

    public ApplicationAssertion name(String name) {
        if (name == null) {
            this.message.remove("name");
        } else {
            this.message.set("name", name);
        }
        return this;
    }

    public ApplicationAssertion systemService(String systemService) {
        if (systemService == null) {
            this.message.remove("systemService");
        } else {
            this.message.set("systemService", systemService);
        }
        return this;
    }

    public ApplicationAssertion user(String user) {
        if (user == null) {
            this.message.remove("user");
        } else {
            this.message.set("user", user);
        }
        return this;
    }

    public ApplicationAssertion startingTime(Instant startingTime) {
        if (startingTime == null) {
            this.message.remove("startingTime");
        } else {
            this.message.set("startingTime", startingTime);
        }
        return this;
    }

    public ApplicationAssertion pids(List<Integer> pids) {
        this.message.set("pids", pids);
        return this;
    }

    public ApplicationAssertion commandLine(String commandLine) {
        if (commandLine == null) {
            this.message.remove("commandLine");
        } else {
            this.message.set("commandLine", commandLine);
        }
        return this;
    }

    public ApplicationAssertion state(State state) {
        if (state == null) {
            this.message.remove("state");
        } else {
            this.message.set("state", state.name());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum State {
        NEW,
        RUNNING,
        SLEEPING,
        WAITING,
        ZOMBIE,
        STOPPED,
        OTHER,
        INVALID,
        SUSPENDED;

    }
}

