/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.staff;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class WorkOrderAssertion
extends MessageEvent
implements Serializable {
    private List<Location> locationList = null;

    public WorkOrderAssertion(String ss) {
        this(new MessageEvent("WorkOrderAssertion", ss).toMessage());
    }

    public WorkOrderAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public WorkOrderAssertion(Message message) {
        super(message);
    }

    private WorkOrderAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public WorkOrderAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public WorkOrderAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static WorkOrderAssertion fromString(String event) {
        return new WorkOrderAssertion(new MessageReader(event).next());
    }

    public Action action() {
        return !this.message.contains("action") ? null : Action.valueOf(this.message.get("action").asString());
    }

    public String employee() {
        return !this.message.contains("employee") ? null : this.message.get("employee").asString();
    }

    public String orderId() {
        return !this.message.contains("orderId") ? null : this.message.get("orderId").asString();
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public Instant localDateTime() {
        return !this.message.contains("localDateTime") ? null : this.message.get("localDateTime").asInstant();
    }

    public Location location() {
        List<Message> components = this.message.components("Location");
        return components.isEmpty() ? null : new Location(components.get(0));
    }

    public WorkOrderAssertion action(Action action) {
        if (action == null) {
            this.message.remove("action");
        } else {
            this.message.set("action", action.name());
        }
        return this;
    }

    public WorkOrderAssertion employee(String employee) {
        if (employee == null) {
            this.message.remove("employee");
        } else {
            this.message.set("employee", employee);
        }
        return this;
    }

    public WorkOrderAssertion orderId(String orderId) {
        if (orderId == null) {
            this.message.remove("orderId");
        } else {
            this.message.set("orderId", orderId);
        }
        return this;
    }

    public WorkOrderAssertion observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public WorkOrderAssertion localDateTime(Instant localDateTime) {
        if (localDateTime == null) {
            this.message.remove("localDateTime");
        } else {
            this.message.set("localDateTime", localDateTime);
        }
        return this;
    }

    public WorkOrderAssertion location(Location location) {
        this.message.components("Location").forEach(v -> this.message.remove((Message)v));
        if (location != null) {
            this.message.add(location.toMessage());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Action {
        Start,
        Pause,
        Complete,
        Cancel;

    }

    public static class Location
    implements Serializable {
        protected Message message;

        public Location() {
            this.message = new Message("Location");
        }

        public Location(Message message) {
            this.message = message;
        }

        public Double latitude() {
            return this.message.get("latitude").asDouble();
        }

        public Double longitude() {
            return this.message.get("longitude").asDouble();
        }

        public Location latitude(Double latitude) {
            this.message.set("latitude", latitude);
            return this;
        }

        public Location longitude(Double longitude) {
            this.message.set("longitude", longitude);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

