/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.staff;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Operation
extends MessageEvent
implements Serializable {
    private List<Parameter> parameterList = null;

    public Operation(String ss) {
        this(new MessageEvent("Operation", ss).toMessage());
    }

    public Operation(MessageEvent event) {
        this(event.toMessage());
    }

    public Operation(Message message) {
        super(message);
    }

    private Operation(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public Operation ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Operation ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Operation fromString(String event) {
        return new Operation(new MessageReader(event).next());
    }

    public String user() {
        return !this.message.contains("user") ? null : this.message.get("user").asString();
    }

    public String server() {
        return !this.message.contains("server") ? null : this.message.get("server").asString();
    }

    public String process() {
        return !this.message.contains("process") ? null : this.message.get("process").asString();
    }

    public String operation() {
        return !this.message.contains("operation") ? null : this.message.get("operation").asString();
    }

    public String result() {
        return !this.message.contains("result") ? null : this.message.get("result").asString();
    }

    public List<Parameter> parameterList() {
        if (this.parameterList != null) {
            return this.parameterList;
        }
        this.parameterList = new ArrayList<Parameter>((Collection)this.message.components("Parameter").stream().map(c -> new Parameter((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Parameter element) {
                super.add(element);
                Operation.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Parameter element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Parameter)) {
                    return false;
                }
                super.remove(o);
                Operation.this.message.remove(((Parameter)o).toMessage());
                return true;
            }

            @Override
            public Parameter remove(int index) {
                Parameter type = (Parameter)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Parameter> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Parameter)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Parameter> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Parameter> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.parameterList;
    }

    public Operation user(String user) {
        if (user == null) {
            this.message.remove("user");
        } else {
            this.message.set("user", user);
        }
        return this;
    }

    public Operation server(String server) {
        if (server == null) {
            this.message.remove("server");
        } else {
            this.message.set("server", server);
        }
        return this;
    }

    public Operation process(String process) {
        if (process == null) {
            this.message.remove("process");
        } else {
            this.message.set("process", process);
        }
        return this;
    }

    public Operation operation(String operation) {
        if (operation == null) {
            this.message.remove("operation");
        } else {
            this.message.set("operation", operation);
        }
        return this;
    }

    public Operation result(String result) {
        if (result == null) {
            this.message.remove("result");
        } else {
            this.message.set("result", result);
        }
        return this;
    }

    public Operation parameterList(List<Parameter> parameter) {
        new ArrayList<Parameter>(this.parameterList()).forEach((Consumer<Parameter>)((Consumer<Object>)v -> this.parameterList.remove(v)));
        this.parameterList.addAll(parameter);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class Parameter
    implements Serializable {
        protected Message message;

        public Parameter() {
            this.message = new Message("Parameter");
        }

        public Parameter(Message message) {
            this.message = message;
        }

        public String type() {
            return !this.message.contains("type") ? null : this.message.get("type").asString();
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public Parameter type(String type) {
            if (type == null) {
                this.message.remove("type");
            } else {
                this.message.set("type", type);
            }
            return this;
        }

        public Parameter name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

