/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class IncidentTracking
extends MessageEvent
implements Serializable {
    public IncidentTracking(String ss) {
        this(new MessageEvent("IncidentTracking", ss).toMessage());
    }

    public IncidentTracking(MessageEvent event) {
        this(event.toMessage());
    }

    public IncidentTracking(Message message) {
        super(message);
    }

    private IncidentTracking(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public IncidentTracking ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public IncidentTracking ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static IncidentTracking fromString(String event) {
        return new IncidentTracking(new MessageReader(event).next());
    }

    public Boolean necessary() {
        return this.message.get("necessary").asBoolean();
    }

    public String incident() {
        return !this.message.contains("incident") ? null : this.message.get("incident").asString();
    }

    public String author() {
        return !this.message.contains("author") ? null : this.message.get("author").asString();
    }

    public String order() {
        return !this.message.contains("order") ? null : this.message.get("order").asString();
    }

    public IncidentTracking necessary(Boolean necessary) {
        if (necessary == null) {
            this.message.remove("necessary");
        } else {
            this.message.set("necessary", necessary);
        }
        return this;
    }

    public IncidentTracking incident(String incident) {
        if (incident == null) {
            this.message.remove("incident");
        } else {
            this.message.set("incident", incident);
        }
        return this;
    }

    public IncidentTracking author(String author) {
        if (author == null) {
            this.message.remove("author");
        } else {
            this.message.set("author", author);
        }
        return this;
    }

    public IncidentTracking order(String order) {
        if (order == null) {
            this.message.remove("order");
        } else {
            this.message.set("order", order);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

