/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Wireless
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMeasurements = new String[]{"connection.failed.association:format=%d:operator=sum:tail=UP:distribution=Poisson", "connection.failed.authentication:format=%d:operator=sum:tail=UP:distribution=Poisson", "connection.failed.dhcp:format=%d:operator=sum:tail=UP:distribution=Poisson", "connection.failed.dns:format=%d:operator=sum:tail=UP:distribution=Poisson", "connection.sucess:format=%d:operator=sum:tail=DOWN:distribution=Normal"};

    public Wireless(String ss) {
        super("Wireless", ss, Instant.now(), declaredMeasurements, new double[5]);
    }

    public Wireless(String ss, String sensor) {
        super("Wireless", ss + "?sensor=" + sensor, Instant.now(), declaredMeasurements, new double[5]);
    }

    public Wireless(String ss, String sensor, Instant ts) {
        super("Wireless", ss + "?sensor=" + sensor, ts, declaredMeasurements, new double[5]);
    }

    public Wireless(MeasurementEvent event) {
        super("Wireless", event.ss(), event.ts(), event.measurements(), event.values());
    }

    public Wireless(Message message) {
        super("Wireless", message.get("ss").asString(), message.get("ts").asInstant(), message.get("measurements").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double assoc() {
        return this.values[0];
    }

    public double auth() {
        return this.values[1];
    }

    public double dhcp() {
        return this.values[2];
    }

    public double dns() {
        return this.values[3];
    }

    public double success() {
        return this.values[4];
    }

    public Wireless assoc(double value) {
        this.values[0] = value;
        return this;
    }

    public Wireless auth(double value) {
        this.values[1] = value;
        return this;
    }

    public Wireless dhcp(double value) {
        this.values[2] = value;
        return this;
    }

    public Wireless dns(double value) {
        this.values[3] = value;
        return this;
    }

    public Wireless success(double value) {
        this.values[4] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.measurements).forEach(m -> message.append("measurements", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

