/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Switch
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMeasurements = new String[]{"data.received:unit=MB:format=%,.0f:operator=sum:tail=UP", "data.sent:unit=MB:format=%,.0f:operator=sum:tail=UP", "usage.ports:format=%d:operator=last:tail=UP:distribution=Normal", "clients:format=%d:operator=last:tail=UP:distribution=Normal"};

    public Switch(String ss) {
        super("Switch", ss, Instant.now(), declaredMeasurements, new double[4]);
    }

    public Switch(String ss, String sensor) {
        super("Switch", ss + "?sensor=" + sensor, Instant.now(), declaredMeasurements, new double[4]);
    }

    public Switch(String ss, String sensor, Instant ts) {
        super("Switch", ss + "?sensor=" + sensor, ts, declaredMeasurements, new double[4]);
    }

    public Switch(MeasurementEvent event) {
        super("Switch", event.ss(), event.ts(), event.measurements(), event.values());
    }

    public Switch(Message message) {
        super("Switch", message.get("ss").asString(), message.get("ts").asInstant(), message.get("measurements").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double dataReceived() {
        return this.values[0];
    }

    public double dataSent() {
        return this.values[1];
    }

    public double usagePorts() {
        return this.values[2];
    }

    public double clients() {
        return this.values[3];
    }

    public Switch dataReceived(double value) {
        this.values[0] = value;
        return this;
    }

    public Switch dataSent(double value) {
        this.values[1] = value;
        return this;
    }

    public Switch usagePorts(double value) {
        this.values[2] = value;
        return this;
    }

    public Switch clients(double value) {
        this.values[3] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.measurements).forEach(m -> message.append("measurements", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

