/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Camera
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMeasurements = new String[]{"people:format=%d:operator=count:tail=UP:distribution=Poisson"};

    public Camera(String ss) {
        super("Camera", ss, Instant.now(), declaredMeasurements, new double[1]);
    }

    public Camera(String ss, String sensor) {
        super("Camera", ss + "?sensor=" + sensor, Instant.now(), declaredMeasurements, new double[1]);
    }

    public Camera(String ss, String sensor, Instant ts) {
        super("Camera", ss + "?sensor=" + sensor, ts, declaredMeasurements, new double[1]);
    }

    public Camera(MeasurementEvent event) {
        super("Camera", event.ss(), event.ts(), event.measurements(), event.values());
    }

    public Camera(Message message) {
        super("Camera", message.get("ss").asString(), message.get("ts").asInstant(), message.get("measurements").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double people() {
        return this.values[0];
    }

    public Camera people(double value) {
        this.values[0] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.measurements).forEach(m -> message.append("measurements", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

