/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.ness.master.Datamart;
import java.util.Collections;
import java.util.List;

public class IncidentRuleMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;

    public IncidentRuleMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled") || message.get("enabled").asBoolean().booleanValue()) continue;
            operation[0] = operation[0] == MasterMounter.Operation.Create ? MasterMounter.Operation.Skip : MasterMounter.Operation.Remove;
            this.entities.remove(owner.id());
            return;
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(IncidentRule.definition, id);
        if (entity == null) {
            entity = new IncidentRule(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    listener.onCreate(entity);
                    break;
                }
                case Update: {
                    listener.onUpdate(entity);
                    break;
                }
                case Remove: {
                    listener.onRemove(entity);
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "description": {
                return this.parseDescription(message);
            }
            case "target": {
                return this.parseTarget(message);
            }
            case "model": {
                return this.parseModel(message);
            }
            case "level": {
                return this.parseLevel(message);
            }
            case "tracking": {
                return this.parseTracking(message);
            }
            case "triggers": {
                return this.parseTriggers(message);
            }
            case "precondition": {
                return this.parsePrecondition(message);
            }
            case "condition": {
                return this.parseCondition(message);
            }
            case "countermeasures": {
                return this.parseCountermeasures(message);
            }
            case "orderTypes": {
                return this.parseOrderTypes(message);
            }
        }
        return message.get(attribute).asString();
    }

    private String parseDescription(Message m) {
        return m.get("description").as(String.class);
    }

    private String parseTarget(Message m) {
        return m.get("target").as(String.class);
    }

    private String parseModel(Message m) {
        return m.get("model").as(String.class);
    }

    private IncidentRule.Level parseLevel(Message m) {
        try {
            return IncidentRule.Level.valueOf(m.get("level").asString());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String parseTracking(Message m) {
        return m.get("tracking").as(String.class);
    }

    private List<String> parseTriggers(Message m) {
        Message.Value value = m.get("triggers");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }

    private String parsePrecondition(Message m) {
        return m.get("precondition").as(String.class);
    }

    private String parseCondition(Message m) {
        return m.get("condition").as(String.class);
    }

    private List<String> parseCountermeasures(Message m) {
        Message.Value value = m.get("countermeasures");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }

    private List<String> parseOrderTypes(Message m) {
        Message.Value value = m.get("orderTypes");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }
}

