/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.mounters.AssetMounter;
import io.intino.ness.master.Datamart;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AssetMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;

    public AssetMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled") || message.get("enabled").asBoolean().booleanValue()) continue;
            operation[0] = operation[0] == MasterMounter.Operation.Create ? MasterMounter.Operation.Skip : MasterMounter.Operation.Remove;
            this.entities.remove(owner.id());
            return;
        }
        Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
        if (components.containsKey("Operation")) {
            this.update(owner, "operationList", new Asset.OperationStructFactory(this).create(components.get("Operation")));
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(Asset.definition, id);
        if (entity == null) {
            entity = new Asset(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    listener.onCreate(entity);
                    break;
                }
                case Update: {
                    listener.onUpdate(entity);
                    break;
                }
                case Remove: {
                    listener.onRemove(entity);
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "tags": {
                return this.parseTags(message);
            }
            case "responsible": {
                return this.parseResponsible(message);
            }
            case "observer": {
                return this.parseObserver(message);
            }
            case "container": {
                return this.parseContainer(message);
            }
            case "model": {
                return this.parseModel(message);
            }
            case "team": {
                return this.parseTeam(message);
            }
            case "place": {
                return this.parsePlace(message);
            }
            case "label": {
                return this.parseLabel(message);
            }
        }
        return message.get(attribute).asString();
    }

    private List<String> parseTags(Message m) {
        Message.Value value = m.get("tags");
        return value.data().isEmpty() ? Collections.emptyList() : value.asList(String.class);
    }

    private String parseResponsible(Message m) {
        return m.get("responsible").asString();
    }

    private String parseObserver(Message m) {
        return m.get("observer").asString();
    }

    private String parseContainer(Message m) {
        return m.get("container").asString();
    }

    private String parseModel(Message m) {
        return m.get("model").asString();
    }

    private String parseTeam(Message m) {
        return m.get("team").as(String.class);
    }

    private String parsePlace(Message m) {
        return m.get("place").asString();
    }

    private String parseLabel(Message m) {
        return m.get("label").as(String.class);
    }
}

