/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.alexandria.event.Event;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.Appliance;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.entities.Hardware;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.datamarts.master.entities.Observer;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.cosmos.datahub.datamarts.master.entities.Part;
import io.intino.cosmos.datahub.datamarts.master.entities.Person;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.cosmos.datahub.datamarts.master.entities.Process;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;
import io.intino.cosmos.datahub.datamarts.master.entities.Software;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.DatamartDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineFile;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MasterDatamart
extends Datamart {
    public static final DatamartDefinition definition = new DatamartDefinitionInternal();

    public List<String> listSnapshots();

    public MasterDatamart snapshot(String var1);

    public Place place(String var1);

    public Stream<Place> places();

    default public List<Place> placeList() {
        return this.places().collect(Collectors.toList());
    }

    default public Optional<Place> place(Predicate<Place> predicate) {
        return this.places().filter(predicate).findFirst();
    }

    public Area area(String var1);

    public Stream<Area> areas();

    default public List<Area> areaList() {
        return this.areas().collect(Collectors.toList());
    }

    default public Optional<Area> area(Predicate<Area> predicate) {
        return this.areas().filter(predicate).findFirst();
    }

    public IncidentRule incidentRule(String var1);

    public Stream<IncidentRule> incidentRules();

    default public List<IncidentRule> incidentRuleList() {
        return this.incidentRules().collect(Collectors.toList());
    }

    default public Optional<IncidentRule> incidentRule(Predicate<IncidentRule> predicate) {
        return this.incidentRules().filter(predicate).findFirst();
    }

    public Model model(String var1);

    public Stream<Model> models();

    default public List<Model> modelList() {
        return this.models().collect(Collectors.toList());
    }

    default public Optional<Model> model(Predicate<Model> predicate) {
        return this.models().filter(predicate).findFirst();
    }

    public OrderType orderType(String var1);

    public Stream<OrderType> orderTypes();

    default public List<OrderType> orderTypeList() {
        return this.orderTypes().collect(Collectors.toList());
    }

    default public Optional<OrderType> orderType(Predicate<OrderType> predicate) {
        return this.orderTypes().filter(predicate).findFirst();
    }

    public Observable observable(String var1);

    public Stream<Observable> observables();

    default public List<Observable> observableList() {
        return this.observables().collect(Collectors.toList());
    }

    default public Optional<Observable> observable(Predicate<Observable> predicate) {
        return this.observables().filter(predicate).findFirst();
    }

    public Person person(String var1);

    public Stream<Person> persons();

    default public List<Person> personList() {
        return this.persons().collect(Collectors.toList());
    }

    default public Optional<Person> person(Predicate<Person> predicate) {
        return this.persons().filter(predicate).findFirst();
    }

    public Process process(String var1);

    public Stream<Process> processes();

    default public List<Process> processList() {
        return this.processes().collect(Collectors.toList());
    }

    default public Optional<Process> process(Predicate<Process> predicate) {
        return this.processes().filter(predicate).findFirst();
    }

    public Asset asset(String var1);

    public Stream<Asset> assets();

    default public List<Asset> assetList() {
        return this.assets().collect(Collectors.toList());
    }

    default public Optional<Asset> asset(Predicate<Asset> predicate) {
        return this.assets().filter(predicate).findFirst();
    }

    public Part part(String var1);

    public Stream<Part> parts();

    default public List<Part> partList() {
        return this.parts().collect(Collectors.toList());
    }

    default public Optional<Part> part(Predicate<Part> predicate) {
        return this.parts().filter(predicate).findFirst();
    }

    public Hardware hardware(String var1);

    public Stream<Hardware> hardwares();

    default public List<Hardware> hardwareList() {
        return this.hardwares().collect(Collectors.toList());
    }

    default public Optional<Hardware> hardware(Predicate<Hardware> predicate) {
        return this.hardwares().filter(predicate).findFirst();
    }

    public Appliance appliance(String var1);

    public Stream<Appliance> appliances();

    default public List<Appliance> applianceList() {
        return this.appliances().collect(Collectors.toList());
    }

    default public Optional<Appliance> appliance(Predicate<Appliance> predicate) {
        return this.appliances().filter(predicate).findFirst();
    }

    public Computer computer(String var1);

    public Stream<Computer> computers();

    default public List<Computer> computerList() {
        return this.computers().collect(Collectors.toList());
    }

    default public Optional<Computer> computer(Predicate<Computer> predicate) {
        return this.computers().filter(predicate).findFirst();
    }

    public Software software(String var1);

    public Stream<Software> softwares();

    default public List<Software> softwareList() {
        return this.softwares().collect(Collectors.toList());
    }

    default public Optional<Software> software(Predicate<Software> predicate) {
        return this.softwares().filter(predicate).findFirst();
    }

    public Observer observer(String var1);

    public Stream<Observer> observers();

    default public List<Observer> observerList() {
        return this.observers().collect(Collectors.toList());
    }

    default public Optional<Observer> observer(Predicate<Observer> predicate) {
        return this.observers().filter(predicate).findFirst();
    }

    public Service service(String var1);

    public Stream<Service> services();

    default public List<Service> serviceList() {
        return this.services().collect(Collectors.toList());
    }

    default public Optional<Service> service(Predicate<Service> predicate) {
        return this.services().filter(predicate).findFirst();
    }

    public Application application(String var1);

    public Stream<Application> applications();

    default public List<Application> applicationList() {
        return this.applications().collect(Collectors.toList());
    }

    default public Optional<Application> application(Predicate<Application> predicate) {
        return this.applications().filter(predicate).findFirst();
    }

    public JavaApplication javaApplication(String var1);

    public Stream<JavaApplication> javaApplications();

    default public List<JavaApplication> javaApplicationList() {
        return this.javaApplications().collect(Collectors.toList());
    }

    default public Optional<JavaApplication> javaApplication(Predicate<JavaApplication> predicate) {
        return this.javaApplications().filter(predicate).findFirst();
    }

    public Stream<TimelineNode> timelines(String var1);

    default public TimelineNode computerTimeline(Computer entity) {
        return this.computerTimeline(entity.id());
    }

    public TimelineNode computerTimeline(String var1);

    default public TimelineNode switchTimeline(Appliance entity) {
        return this.switchTimeline(entity.id());
    }

    public TimelineNode switchTimeline(String var1);

    default public TimelineNode cellularGatewayTimeline(Appliance entity) {
        return this.cellularGatewayTimeline(entity.id());
    }

    public TimelineNode cellularGatewayTimeline(String var1);

    default public TimelineNode wirelessTimeline(Appliance entity) {
        return this.wirelessTimeline(entity.id());
    }

    public TimelineNode wirelessTimeline(String var1);

    default public TimelineNode cameraTimeline(Appliance entity) {
        return this.cameraTimeline(entity.id());
    }

    public TimelineNode cameraTimeline(String var1);

    default public TimelineNode applicationTimeline(Application entity) {
        return this.applicationTimeline(entity.id());
    }

    public TimelineNode applicationTimeline(String var1);

    public Stream<ReelNode> reels(String var1);

    default public ReelNode statusReel(Observable entity) {
        return this.statusReel(entity.id());
    }

    public ReelNode statusReel(String var1);

    public Stream<ReelNode> statusReels();

    public static interface TimelineNode
    extends ChronosNode {
        public static final AtomicBoolean AlwaysDownloadFromDatahub = new AtomicBoolean();

        public boolean exists();

        public TimelineFile.TimeModel timeModel();

        public TimelineFile.SensorModel sensorModel();

        public Instant first();

        public Instant last();

        public Timeline get();

        public void setEventListener(EventListener var1);

        public static interface EventListener {
            public void onEventReceived(TimelineNode var1, Event var2);
        }
    }

    public static interface ReelNode
    extends ChronosNode {
        public boolean exists();

        public Reel.State stateOf(String var1);

        default public List<Reel.State> stateOf(List<String> signals) {
            return signals.isEmpty() ? Collections.emptyList() : this.stateOf(signals.stream());
        }

        public List<Reel.State> stateOf(Stream<String> var1);

        public Reel get(Period var1);

        public Reel get(Instant var1, Instant var2, Period var3);

        public void setEventListener(EventListener var1);

        public static interface EventListener {
            public void onEventReceived(ReelNode var1, Event var2);
        }
    }

    public static final class DatamartDefinitionInternal
    implements DatamartDefinition {
        private DatamartDefinition definition;

        private DatamartDefinitionInternal() {
        }

        @Override
        public String name() {
            return this.definition().name();
        }

        @Override
        public Datamart.Scale scale() {
            return this.definition().scale();
        }

        @Override
        public DatamartDefinition.Query<EntityDefinition> entities() {
            return this.definition().entities();
        }

        @Override
        public DatamartDefinition.Query<StructDefinition> structs() {
            return this.definition().structs();
        }

        @Override
        public Optional<EntityDefinition> entity(String fullName) {
            return this.definition().entity(fullName);
        }

        @Override
        public Optional<StructDefinition> struct(String fullName) {
            return this.definition().struct(fullName);
        }

        private DatamartDefinition definition() {
            if (this.definition == null) {
                throw new IllegalStateException("MasterDatamart is not initialized");
            }
            return this.definition;
        }
    }

    public static interface ChronosNode {
        public String id();

        public String type();

        public void dispose();
    }

    public static class Entities {
        private final MasterDatamart datamart;
        private final Map<EntityDefinition, Map<String, MasterEntity>> entitiesByType;

        public Entities(MasterDatamart datamart) {
            this.datamart = datamart;
            this.entitiesByType = new ConcurrentHashMap<EntityDefinition, Map<String, MasterEntity>>();
            datamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> this.entitiesByType.put((EntityDefinition)entity, new ConcurrentHashMap()));
        }

        public MasterDatamart datamart() {
            return this.datamart;
        }

        public int size() {
            return this.entitiesByType.values().stream().mapToInt(Map::size).sum();
        }

        public MasterEntity get(String id) {
            return this.mapOf(id).map(map -> (MasterEntity)map.get(id)).orElse(null);
        }

        public <T extends MasterEntity> T getDescendant(EntityDefinition definition, String id) {
            T entity = this.get(definition, id);
            return (T)(entity != null ? entity : (MasterEntity)definition.descendants().stream().filter(descendant -> !descendant.isAbstract()).map(descendant -> this.get((EntityDefinition)descendant, id)).filter(Objects::nonNull).findFirst().orElse(null));
        }

        public <T extends MasterEntity> T get(EntityDefinition type, String id) {
            return (T)(this.entitiesByType.containsKey(type) ? this.entitiesByType.get(type).get(id) : null);
        }

        public void add(MasterEntity entity) {
            this.entitiesByType.get(entity.getDefinition()).put(entity.id(), entity);
        }

        public void remove(String id) {
            this.mapOf(id).ifPresent(map -> map.remove(id));
        }

        public Stream<MasterEntity> stream() {
            return this.entitiesByType.values().stream().flatMap(map -> map.values().stream());
        }

        public <T extends MasterEntity> Stream<T> stream(EntityDefinition type) {
            return this.entitiesByType.containsKey(type) ? this.entitiesByType.get(type).values().stream() : Stream.empty();
        }

        public Stream<Entity> streamGeneric() {
            return this.entitiesByType.values().stream().flatMap(map -> map.values().stream());
        }

        private Optional<Map<String, MasterEntity>> mapOf(String id) {
            return this.entitiesByType.values().stream().filter(map -> map.containsKey(id)).findFirst();
        }
    }
}

