/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.Base64;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerConfiguration;
import io.intino.consul.container.box.Utils;
import io.intino.consul.container.box.actions.WindowsUpgradeCommand;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.terminal.RequestAttendant;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class UpgradeRequest
extends ContainerRequest {
    public static final String ID = "upgrade";
    private final ContainerBox box;
    private final ContainerConfiguration configuration;
    private static final AtomicBoolean upgrading = new AtomicBoolean(false);

    public UpgradeRequest(ContainerBox box, ContainerConfiguration configuration) {
        this.box = box;
        this.configuration = configuration;
    }

    @Override
    public String id() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        if (upgrading.get()) {
            return new RequestAttendant.RequestResult(false, "Upgrade in progress");
        }
        upgrading.set(true);
        BytesMessage message = (BytesMessage)request;
        try {
            String version = this.parameter(request, "version");
            Logger.info("Upgrading Consul Container to: " + version);
            File installDirectory = UpgradeRequest.installDirectory();
            File jarFile = this.jarFile();
            String jarName = jarFile.getName().toLowerCase().replace(".jar", "");
            this.saveConfigurationFiles(request, installDirectory, jarName);
            byte[] payload = new byte[(int)message.getBodyLength()];
            message.readBytes(payload);
            File tempFile = new File(installDirectory, "consul.new.jar");
            Files.write(tempFile.toPath(), payload, new OpenOption[0]);
            if (Utils.isUnix()) {
                new Thread(() -> {
                    try {
                        this.box.beforeStop();
                        Files.move(tempFile.toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        UpgradeRequest.runProcess(new ProcessBuilder(new String[0]).command("systemctl", "restart", jarName));
                    }
                    catch (IOException e) {
                        Logger.error(e);
                    }
                }).start();
            } else if (Utils.isWindows()) {
                new WindowsUpgradeCommand(installDirectory).execute();
            }
            upgrading.set(false);
            RequestAttendant.RequestResult requestResult = new RequestAttendant.RequestResult(true, "Consul upgraded. Restart in progress...");
            return requestResult;
        }
        catch (Throwable e) {
            Logger.error(e);
            RequestAttendant.RequestResult requestResult = new RequestAttendant.RequestResult(false, e.getMessage());
            return requestResult;
        }
        finally {
            upgrading.set(false);
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private void saveConfigurationFiles(Message request, File installDirectory, String serviceName) throws JMSException, IOException, InterruptedException {
        String jts = this.parameter(request, "jts");
        String jks = this.parameter(request, "jks");
        if (jts == null || jks == null) {
            return;
        }
        String password = this.parameter(request, "password");
        Files.write(this.configuration.keyStoreFile().toPath(), Base64.decode(jks), new OpenOption[0]);
        Files.write(this.configuration.trustStoreFile().toPath(), Base64.decode(jts), new OpenOption[0]);
        if (Utils.isUnix()) {
            UpgradeRequest.updateServiceFile(password, serviceName);
        } else if (Utils.isWindows()) {
            this.updateWrapperFile(installDirectory, password);
        }
    }

    private void updateWrapperFile(File installDirectory, String password) {
        try {
            File file = new File(installDirectory, "win64" + File.separator + "wrapper.conf");
            String content = Files.readString(file.toPath());
            Files.writeString(file.toPath(), (CharSequence)content.replaceAll("store_password=.*\"", "store_password=" + password + "\""), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void updateServiceFile(String password, String serviceName) throws IOException, InterruptedException {
        File file = UpgradeRequest.serviceFile(serviceName);
        if (file != null && file.exists()) {
            String content = Files.readString(file.toPath());
            content = content.replaceAll("store_password=.* ", "store_password=" + password + " ");
            Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
            Process process = new ProcessBuilder("systemctl", "daemon-reload").redirectErrorStream(true).start();
            process.waitFor(4L, TimeUnit.SECONDS);
        }
    }

    private static void runProcess(ProcessBuilder processBuilder) {
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                processBuilder.start();
            }
            catch (IOException | InterruptedException e) {
                Logger.error(e);
            }
        }).start();
    }

    private static File serviceFile(String serviceName) throws IOException {
        try {
            Process process = new ProcessBuilder("systemctl", "status", serviceName + ".service").redirectErrorStream(true).start();
            process.waitFor(4L, TimeUnit.SECONDS);
            String result = new String(process.getInputStream().readAllBytes());
            String loaded = result.lines().map(String::trim).filter(l -> l.startsWith("Loaded:")).findFirst().orElse(null);
            if (loaded == null) {
                return null;
            }
            return new File(loaded.substring(loaded.indexOf("(") + 1, loaded.indexOf(";")));
        }
        catch (InterruptedException e) {
            Logger.error(e);
            return null;
        }
    }

    public static File installDirectory() {
        return new File(UpgradeRequest.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " ")).getParentFile();
    }

    private File jarFile() {
        return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " "));
    }
}

