/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class UpgradeActivityRequest
extends ContainerRequest {
    public static final String ID = "upgradeActivity";
    private final ContainerBox box;
    private final Activity.Context context;
    private final ContainerStore store;

    public UpgradeActivityRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
        this.box = box;
        this.context = context;
        this.store = store;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        BytesMessage message = (BytesMessage)request;
        try {
            String newActivity = this.activity(request);
            Logger.info("Upgrading activity to " + newActivity);
            if (this.box.activities().enabledActivities().contains(newActivity)) {
                Logger.info("Activity already updated: " + newActivity);
                return new RequestAttendant.RequestResult(true, "Activity already updated: " + newActivity);
            }
            String lastActivity = this.lastActivity(newActivity);
            if (lastActivity == null) {
                Logger.info("Activity not found: " + newActivity);
                return new RequestAttendant.RequestResult(false, "Activity not found: " + newActivity);
            }
            this.install(message, newActivity);
            this.copyConfiguration(lastActivity, newActivity);
            boolean result = this.box.activities().disableActivity(lastActivity);
            if (!result) {
                return new RequestAttendant.RequestResult(false, "Impossible to disable current activity");
            }
            result = this.box.activities().uninstallActivity(lastActivity);
            if (!result) {
                return new RequestAttendant.RequestResult(false, "Impossible to uninstall current activity");
            }
            result = this.box.activities().enableActivity(newActivity);
            new Thread(() -> new ObserverAssertionAction(this.box, this.context).execute(), newActivity + "-upgrade").start();
            Logger.info("Upgraded activity to " + newActivity);
            return new RequestAttendant.RequestResult(result, result ? "Upgraded activity to " + newActivity : "Impossible to enable new activity");
        }
        catch (JMSException e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private void copyConfiguration(String last, String newActivity) {
        if (last == null) {
            return;
        }
        this.store.save();
        this.box.activities().updateConfiguration(newActivity, this.store.activityParams(last));
    }

    private String lastActivity(String artifact) {
        String[] split = artifact.split(":");
        String id = split[0] + ":" + split[1];
        return this.box.activities().enabledActivities().stream().filter(a -> a.startsWith(id + ":")).findFirst().orElse(null);
    }

    private void install(BytesMessage message, String artifact) throws JMSException {
        byte[] payload = new byte[(int)message.getBodyLength()];
        message.readBytes(payload);
        this.box.activities().installActivity(artifact, payload);
    }
}

