/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import javax.jms.Message;

public class EnableActivityRequest
extends ContainerRequest {
    public static final String ID = "enableActivity";
    private final ContainerBox box;
    private final Activity.Context context;

    public EnableActivityRequest(ContainerBox box, Activity.Context context) {
        this.box = box;
        this.context = context;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            String activityId = this.activity(request);
            if (activityId == null) {
                return new RequestAttendant.RequestResult(false, "Activity not found");
            }
            boolean result = this.box.activities().enableActivity(activityId);
            new Thread(() -> new ObserverAssertionAction(this.box, this.context).execute(), activityId + "-enable").start();
            return new RequestAttendant.RequestResult(result, result ? "Activity enabled" : "Impossible to enable activity");
        }
        catch (Throwable e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }
}

