/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.remote.RemoteFileSystem;
import io.intino.consul.container.box.os.remote.RemoteProcessRunner;
import io.intino.consul.container.box.os.remote.linux.LinuxOSProcess;
import io.intino.consul.framework.Activity;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oshi.driver.linux.proc.UpTime;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class RemoteOperatingSystem
implements Activity.System.OperatingSystem {
    private final RemoteProcessRunner processRunner;
    private final RemoteFileSystem remoteFileSystem;
    private final long bootTime;
    private long userHz;
    private long pageSize;
    private static Set<String> systemProcesses;
    public static final Pattern DIGITS;

    public RemoteOperatingSystem(Session session) throws IOException {
        this.remoteFileSystem = new RemoteFileSystem(session);
        this.processRunner = new RemoteProcessRunner(session);
        this.bootTime = this.booTime();
        if (systemProcesses == null || systemProcesses.isEmpty()) {
            systemProcesses = this.systemProcesses();
        }
        this.updateProperties();
    }

    @Override
    public Activity.System.OperatingSystem.Name name() {
        try {
            return this.processRunner().execute("uname").trim().equals("Linux") ? Activity.System.OperatingSystem.Name.Unix : Activity.System.OperatingSystem.Name.Mac;
        }
        catch (Exception e) {
            Logger.error(e);
            return Activity.System.OperatingSystem.Name.Unix;
        }
    }

    @Override
    public long bootTimeSeconds() {
        return this.bootTime;
    }

    @Override
    public Activity.System.FileSystem fileSystem() throws IOException {
        return this.remoteFileSystem;
    }

    @Override
    public Activity.System.ProcessRunner processRunner() {
        return this.processRunner;
    }

    @Override
    public List<? extends Activity.System.OSProcess> processes() throws IOException {
        return this.getPidFiles().map(f -> {
            try {
                return new LinuxOSProcess((File)f, this, systemProcesses);
            }
            catch (Exception e) {
                Logger.error(e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private Stream<File> getPidFiles() throws IOException {
        File directory = new File("/proc");
        return this.fileSystem().listDirectory(directory.getAbsolutePath()).stream().filter(file -> DIGITS.matcher((CharSequence)file).matches()).map(n -> new File(directory, (String)n));
    }

    @Override
    public int processCount() {
        return 0;
    }

    private long booTime() {
        long tempBT = this.bootTimeFromProc();
        if (tempBT == 0L) {
            tempBT = System.currentTimeMillis() / 1000L - (long)UpTime.getSystemUptimeSeconds();
        }
        return tempBT;
    }

    public long bootTimeFromProc() {
        try {
            return this.fileSystem().readFile("/proc/stat").lines().filter(stat -> stat.startsWith("btime")).findFirst().map(t2 -> ParseUtil.parseLongOrDefault(ParseUtil.whitespaces.split((CharSequence)t2)[1], 0L)).orElse(0L);
        }
        catch (IOException e) {
            Logger.error(e);
            return 0L;
        }
    }

    @Override
    public long userHz() {
        return this.userHz;
    }

    @Override
    public long pageSize() {
        return this.pageSize;
    }

    @Override
    public Activity.System.Measurements measurements() {
        return null;
    }

    private void updateProperties() {
        try {
            Map<Integer, Long> auxv = this.queryAuxv();
            long hz = auxv.getOrDefault(17, 0L);
            this.userHz = hz > 0L ? hz : ParseUtil.parseLongOrDefault(this.processRunner.execute("getconf", "CLK_TCK"), 100L);
            long pageSize = auxv.getOrDefault(6, 0L);
            this.pageSize = pageSize > 0L ? pageSize : ParseUtil.parseLongOrDefault(this.processRunner.execute("getconf", "PAGE_SIZE"), 4096L);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private Map<Integer, Long> queryAuxv() {
        try {
            int key;
            byte[] array = this.fileSystem().readFileBytes("/proc/self/auxv");
            ByteBuffer buff = ByteBuffer.wrap(array);
            HashMap<Integer, Long> auxvMap = new HashMap<Integer, Long>();
            do {
                if ((key = FileUtil.readNativeLongFromBuffer(buff).intValue()) <= 0) continue;
                auxvMap.put(key, FileUtil.readNativeLongFromBuffer(buff).longValue());
            } while (key > 0);
            return auxvMap;
        }
        catch (IOException e) {
            Logger.error(e);
            return Map.of();
        }
    }

    private Set<String> systemProcesses() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(Activity.System.OperatingSystem.Name.Unix.name().toLowerCase() + ".system.processes.txt");
        if (stream == null) {
            Logger.error("Resource not found: " + Activity.System.OperatingSystem.Name.Unix.name().toLowerCase() + ".system.processes.txt");
            return Set.of();
        }
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toSet());
    }

    static {
        DIGITS = Pattern.compile("\\d+");
    }
}

