/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.local;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.local.LocalFileSystem;
import io.intino.consul.container.box.os.local.LocalProcessRunner;
import io.intino.consul.framework.Activity;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;

public class LocalOperatingSystem
implements Activity.System.OperatingSystem {
    private final Activity.System.OperatingSystem.Name name;
    private final SystemInfo si;
    private static Set<String> systemProcesses;

    public LocalOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        Activity.System.OperatingSystem.Name name = os.contains("win") ? Activity.System.OperatingSystem.Name.Windows : (this.name = os.contains("mac") ? Activity.System.OperatingSystem.Name.Mac : Activity.System.OperatingSystem.Name.Unix);
        if (systemProcesses == null || systemProcesses.isEmpty()) {
            systemProcesses = this.systemProcesses();
        }
        this.si = new SystemInfo();
        LogManager.getCurrentLoggers().asIterator().forEachRemaining(c -> ((org.apache.log4j.Logger)c).setLevel(Level.ERROR));
    }

    private Set<String> systemProcesses() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.name.name().toLowerCase() + ".system.processes.txt");
        if (stream == null) {
            Logger.error("Resource not found: " + this.name.name().toLowerCase() + ".system.processes.txt");
            return Set.of();
        }
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toSet());
    }

    @Override
    public Activity.System.OperatingSystem.Name name() {
        return this.name;
    }

    @Override
    public long bootTimeSeconds() {
        return this.si.getOperatingSystem().getSystemBootTime();
    }

    @Override
    public long userHz() {
        return this.si.getHardware().getProcessor().getMaxFreq();
    }

    @Override
    public long pageSize() {
        return this.si.getHardware().getMemory().getPageSize();
    }

    @Override
    public Activity.System.Measurements measurements() {
        return new Activity.System.Measurements(){

            @Override
            public long usageRAM() {
                GlobalMemory memory = LocalOperatingSystem.this.si.getHardware().getMemory();
                return LocalOperatingSystem.inMb(memory.getTotal() - memory.getAvailable());
            }

            @Override
            public long usageHDD() {
                File file = new File(".");
                return LocalOperatingSystem.inMb(file.getTotalSpace() - file.getFreeSpace());
            }

            @Override
            public double usageCPU() {
                CentralProcessor cpu = LocalOperatingSystem.this.si.getHardware().getProcessor();
                return LocalOperatingSystem.asPercent(cpu.getSystemLoadAverage(3)[2]);
            }

            @Override
            public int usageFiles() {
                try {
                    return (int)LocalOperatingSystem.this.si.getOperatingSystem().getProcesses().stream().mapToLong(OSProcess::getOpenFiles).sum();
                }
                catch (Throwable e) {
                    return 0;
                }
            }

            @Override
            public long usageThreads() {
                return LocalOperatingSystem.this.si.getOperatingSystem().getThreadCount();
            }

            @Override
            public long dataReceived() {
                NetworkIF networkIF = LocalOperatingSystem.this.si.getHardware().getNetworkIFs().stream().filter(i -> i.getIfOperStatus().equals((Object)NetworkIF.IfOperStatus.UP) && i.getIPv4addr().length > 0).findFirst().orElse(null);
                if (networkIF == null) {
                    return 0L;
                }
                networkIF.updateAttributes();
                return networkIF.getBytesRecv() / 0x100000L;
            }

            @Override
            public long dataSent() {
                NetworkIF networkIF = LocalOperatingSystem.this.si.getHardware().getNetworkIFs().stream().filter(i -> i.getIPv4addr().length > 0).findFirst().orElse(null);
                if (networkIF == null) {
                    return 0L;
                }
                networkIF.updateAttributes();
                return networkIF.getBytesSent() / 0x100000L;
            }

            @Override
            public double temperatureKernel() {
                return LocalOperatingSystem.this.readTemperature();
            }

            @Override
            public double temperatureExternal() {
                return 0.0;
            }
        };
    }

    private double readTemperature() {
        try {
            if (this.name == Activity.System.OperatingSystem.Name.Unix && new File("/opt/vc/bin/vcgencmd").exists()) {
                return LocalOperatingSystem.readTemperatureInUnixOS();
            }
            return this.si.getHardware().getSensors().getCpuTemperature();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private static double readTemperatureInUnixOS() throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec("/opt/vc/bin/vcgencmd measure_temp");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String s = br.readLine();
            if (s != null) {
                double d = Float.parseFloat(s.replace("temp=", "").replace("'C", ""));
                return d;
            }
            p.waitFor();
            double d = 0.0;
            return d;
        }
    }

    public static long inMb(long value) {
        return value / 0x100000L;
    }

    private static double asPercent(double number) {
        return Math.floor(number * 100.0) / 100.0;
    }

    @Override
    public Activity.System.FileSystem fileSystem() {
        return new LocalFileSystem(this);
    }

    @Override
    public Activity.System.ProcessRunner processRunner() {
        return new LocalProcessRunner();
    }

    public List<Activity.System.OSProcess> processes() {
        Map<Integer, String> services = this.systemServices();
        if (this.name == Activity.System.OperatingSystem.Name.Unix) {
            this.searchJavaServices(services);
        }
        return this.si.getOperatingSystem().getProcesses().stream().map(p -> this.map((OSProcess)p, (String)services.get(p.getProcessID()))).toList();
    }

    private void searchJavaServices(Map<Integer, String> services) {
        Activity.System.ProcessRunner runner = this.processRunner();
        try {
            Map<Integer, String> serviceNames = LocalOperatingSystem.run(runner, "systemctl", "--type=service", "--state=running").lines().filter(l -> l.contains(".service")).map(l -> l.substring(0, l.indexOf(".service")).trim()).collect(Collectors.toMap(l -> this.parse(LocalOperatingSystem.run(runner, "systemctl", "show", "--value", "--property", "MainPID", l)), l -> l));
            services.putAll(serviceNames);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private Integer parse(String pid) {
        try {
            return Integer.parseInt(pid.trim());
        }
        catch (NumberFormatException e) {
            Logger.error(e);
            return 0;
        }
    }

    private static String run(Activity.System.ProcessRunner runner, String ... command) {
        try {
            return runner.execute(command);
        }
        catch (Exception e) {
            Logger.error(e);
            return "";
        }
    }

    private Map<Integer, String> systemServices() {
        return this.si.getOperatingSystem().getServices().stream().collect(Collectors.toMap(OSService::getProcessID, OSService::getName, (v1, v2) -> v2));
    }

    @Override
    public int processCount() {
        return this.si.getOperatingSystem().getProcessCount();
    }

    private Activity.System.OSProcess map(final OSProcess p, final String serviceName) {
        return new Activity.System.OSProcess(){

            @Override
            public String name() {
                return p.getName();
            }

            @Override
            public String path() {
                return p.getPath();
            }

            @Override
            public String commandLine() {
                return p.getCommandLine();
            }

            @Override
            public List<String> arguments() {
                return p.getArguments();
            }

            @Override
            public String user() {
                return p.getUser();
            }

            @Override
            public String group() {
                return p.getGroup();
            }

            @Override
            public Activity.System.OSProcess.State state() {
                return Activity.System.OSProcess.State.valueOf(p.getState().name());
            }

            @Override
            public boolean isOSProcess() {
                String name = p.getName();
                if (systemProcesses.contains(name) || systemProcesses.contains(name.split("/")[0])) {
                    return true;
                }
                if (LocalOperatingSystem.this.name == Activity.System.OperatingSystem.Name.Windows) {
                    return p.getCommandLine().startsWith("C:\\Windows");
                }
                if (LocalOperatingSystem.this.name == Activity.System.OperatingSystem.Name.Mac) {
                    return p.getCommandLine().startsWith("/System/");
                }
                return false;
            }

            @Override
            public boolean isSystemService() {
                return serviceName != null;
            }

            @Override
            public String systemServiceName() {
                return serviceName;
            }

            @Override
            public int processID() {
                return p.getProcessID();
            }

            @Override
            public int parentProcessID() {
                return p.getParentProcessID();
            }

            @Override
            public int threadCount() {
                return p.getThreadCount();
            }

            @Override
            public long virtualSize() {
                return p.getVirtualSize();
            }

            @Override
            public long residentSetSize() {
                return p.getResidentSetSize();
            }

            @Override
            public long kernelTime() {
                return p.getKernelTime();
            }

            @Override
            public long userTime() {
                return p.getUserTime();
            }

            @Override
            public long upTime() {
                return p.getUpTime();
            }

            @Override
            public long startTime() {
                return p.getStartTime();
            }

            @Override
            public long bytesRead() {
                return p.getBytesRead();
            }

            @Override
            public long bytesWritten() {
                return p.getBytesWritten();
            }

            @Override
            public long openFiles() {
                return p.getOpenFiles();
            }

            @Override
            public long openFilesLimit() {
                return p.getHardOpenFileLimit();
            }

            @Override
            public double processCpuLoadCumulative() {
                return p.getProcessCpuLoadCumulative();
            }

            @Override
            public int getBitness() {
                return p.getBitness();
            }
        };
    }
}

