/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.activity;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerConfiguration;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.activity.ActivityLoader;
import io.intino.consul.container.box.activity.ActivityStore;
import io.intino.consul.container.box.os.local.LocalSystem;
import io.intino.consul.container.box.os.remote.RemoteSystem;
import io.intino.consul.framework.Activity;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivityManager {
    public static final String ROOT_ACTIVITIES = "root#activities";
    private final HashMap<String, Activity> enabledActivities;
    private final ContainerConfiguration configuration;
    private final Activity.Context context;
    private final ContainerStore store;
    private final ActivityLoader loader;

    public ActivityManager(ContainerConfiguration configuration, Activity.Context context, ContainerStore store) {
        this.configuration = configuration;
        this.context = context;
        this.store = store;
        this.loader = new ActivityLoader();
        this.enabledActivities = new HashMap();
    }

    public List<String> enabledActivities() {
        return new ArrayList<String>(this.enabledActivities.keySet());
    }

    public void loadActivitiesFromStore() {
        Map<String, Boolean> activities = this.activities();
        if (activities == null) {
            return;
        }
        activities.keySet().stream().filter(activities::get).forEach(this::enableActivity);
    }

    public void stopActivities() {
        this.enabledActivities.values().forEach(ActivityManager::stop);
    }

    public boolean enableActivity(String activityId) {
        Activity activity = this.enabledActivities.get(activityId);
        if (activity != null) {
            return true;
        }
        activity = this.loader.load(this.store.activity(activityId));
        if (activity == null) {
            return false;
        }
        boolean enabled = this.configure(activity, this.store.activityParams(activityId));
        if (!enabled) {
            return false;
        }
        this.enabledActivities.put(activityId, activity);
        this.update(activityId, true);
        Logger.info("Enabled activity " + activityId);
        new Thread(activity::onStart).start();
        return true;
    }

    public boolean disableActivity(String activityId) {
        Activity activity = this.enabledActivities.get(activityId);
        if (activity == null) {
            return false;
        }
        ActivityManager.stop(activity);
        this.enabledActivities.remove(activityId);
        this.update(activityId, false);
        Logger.info("Disabled activity " + activityId);
        return true;
    }

    public boolean updateConfiguration(String activityId, Map<String, String> configuration) {
        if (!this.activities().containsKey(activityId)) {
            return false;
        }
        this.store.saveActivityParams(activityId, configuration);
        Logger.info("Updated configuration of " + activityId);
        return true;
    }

    public synchronized void installActivity(String activityId, byte[] payload) {
        Map<String, Boolean> activities = this.activities();
        if (!activities.containsKey(activityId)) {
            activities.put(activityId, false);
        }
        this.store.put(ROOT_ACTIVITIES, activities);
        this.store.saveActivity(activityId, payload);
        Logger.info("Installed activity " + activityId);
    }

    public synchronized boolean uninstallActivity(String activityId) {
        Map<String, Boolean> activities = this.activities();
        if (activities == null) {
            return false;
        }
        activities.remove(activityId);
        this.store.put(ROOT_ACTIVITIES, activities);
        this.remove(activityId, this.enabledActivities.remove(activityId));
        this.store.save();
        Logger.info("Uninstalled activity " + activityId);
        return true;
    }

    public synchronized void saveConfigurations() {
        this.enabledActivities.forEach((k, v) -> this.store.saveActivityParams((String)k, v.currentConfiguration()));
    }

    private void update(String activityId, boolean value) {
        Map<String, Boolean> activities = this.activities();
        activities.put(activityId, value);
        this.store.put(ROOT_ACTIVITIES, activities);
    }

    private void remove(String activityId, Activity activity) {
        if (activity != null) {
            ActivityManager.stop(activity);
            this.clearStore(activity.id());
            ActivityManager.closeClassLoader(activity);
            this.stopActivityThreads(activityId);
            System.gc();
        }
        this.store.removeActivity(activityId);
    }

    private void stopActivityThreads(String artifact) {
        Thread.getAllStackTraces().keySet().stream().filter(t2 -> t2.getContextClassLoader() instanceof URLClassLoader && new File(((URLClassLoader)t2.getContextClassLoader()).getURLs()[0].getFile()).equals(this.store.activity(artifact))).forEach(Thread::interrupt);
    }

    private boolean configure(Activity a, Map<String, String> args) {
        try {
            return a.configure(new Activity.Context(this.context.terminal(), args.containsKey("remote-server") ? this.remoteSystem(args) : new LocalSystem(this.configuration.ispProviderToken()), this.context.hostName(), this.context.observer(), this.context.ss(), this.mergeArgs(args, this.context.initialConfiguration())), new ActivityStore(a.id(), this.store));
        }
        catch (Throwable e) {
            Logger.error(e);
            return false;
        }
    }

    private Activity.System remoteSystem(Map<String, String> args) throws Exception {
        return new RemoteSystem(args.get("private-key"), args.get("remote-server"), args.get("remote-port"), args.get("remote-user"));
    }

    private Map<String, String> mergeArgs(Map<String, String> params, Map<String, String> args) {
        HashMap<String, String> merged = new HashMap<String, String>(params);
        merged.putAll(args);
        return merged;
    }

    private static void stop(Activity activity) {
        try {
            activity.onStop();
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    public Map<String, Boolean> activities() {
        return this.store.getOrElse(ROOT_ACTIVITIES, ContainerStore.asBooleanMap, new HashMap());
    }

    private void clearStore(String id) {
        this.store.removeAll(k -> k.startsWith(id + "#"));
    }

    private static void closeClassLoader(Activity activity) {
        ClassLoader classLoader = activity.getClass().getClassLoader();
        if (classLoader instanceof ActivityLoader.JarClassLoader) {
            classLoader.clearAssertionStatus();
            try {
                ((ActivityLoader.JarClassLoader)classLoader).close();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }
}

