/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.exceptions;

import io.intino.alexandria.exceptions.AlexandriaError;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class AlexandriaException
extends Throwable
implements AlexandriaError {
    private final Map<String, String> parameters;
    private final String code;

    public AlexandriaException(String code, String message) {
        this(code, message, Collections.emptyMap());
    }

    public AlexandriaException(String code, String message, Map<String, String> parameters) {
        super(message);
        this.code = code;
        this.parameters = parameters;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.getMessage();
    }

    @Override
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        return "{\n\t\"code\": \"" + this.code() + "\",\n\t\"detailMessage\": \"" + this.message() + "\",\n" + this.parametersString() + "}";
    }

    private String parametersString() {
        return this.parameters == null ? "" : "\t\"parameters\": {\n\t\t" + this.parameters().entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(",\n\t\t")) + "\n\t}\n";
    }
}

