/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileEntryInputStream
extends InputStream {
    private final ZipFile zipFile;
    private final InputStream inputStream;

    public ZipFileEntryInputStream(String filename, String entryName) throws IOException {
        this.zipFile = new ZipFile(filename);
        this.inputStream = this.zipFile.getInputStream(this.zipFile.getEntry(entryName));
    }

    public ZipFileEntryInputStream(ZipFile file, ZipEntry entry) throws IOException {
        this.zipFile = file;
        this.inputStream = this.zipFile.getInputStream(entry);
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.inputStream.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.inputStream.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.inputStream.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.zipFile.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.inputStream.transferTo(out);
    }
}

