/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.message;

import io.intino.alexandria.FS;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.message.MessageEventTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageEventSource
implements Datalake.Store.Source<MessageEvent> {
    private final File root;

    public MessageEventSource(File file) {
        this.root = file;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Scale scale() {
        return Optional.ofNullable(this.first()).map(Datalake.Store.Tub::scale).orElse(null);
    }

    @Override
    public Datalake.Store.Tub<MessageEvent> first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.Store.Tub<MessageEvent> last() {
        List files = this.tubFiles().collect(Collectors.toList());
        return files.isEmpty() ? null : new MessageEventTub((File)files.get(files.size() - 1));
    }

    @Override
    public Stream<Datalake.Store.Tub<MessageEvent>> tubs() {
        return this.tubFiles().map(MessageEventTub::new);
    }

    @Override
    public Datalake.Store.Tub<MessageEvent> on(Timetag tag) {
        return new MessageEventTub(new File(this.root, tag.value() + Event.Format.Message.extension()));
    }

    private Stream<File> tubFiles() {
        return FS.filesIn(this.root, pathname -> pathname.getName().endsWith(Event.Format.Message.extension()));
    }
}

