/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.event.resource.ResourceEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Datalake {
    public static final String MessageStoreFolder = "messages";
    public static final String MeasurementStoreFolder = "measurements";
    public static final String ResourceStoreFolder = "resources";

    public Store<MessageEvent> messageStore();

    public Store<MeasurementEvent> measurementStore();

    public ResourceStore resourceStore();

    public static interface ResourceStore
    extends Store<ResourceEvent> {
        default public Optional<ResourceEvent> find(String rei) {
            return this.find(new ResourceEvent.REI(rei));
        }

        public Optional<ResourceEvent> find(ResourceEvent.REI var1);
    }

    public static interface Store<T extends Event> {
        public Stream<Tank<T>> tanks();

        default public boolean containsTank(String tank) {
            return this.tanks().anyMatch(t2 -> t2.name().equals(tank));
        }

        public Tank<T> tank(String var1);

        default public Stream<T> content() {
            return this.tanks().flatMap(Tank::content);
        }

        default public Scale scale() {
            return ((Stream)this.tanks().parallel()).map(Tank::scale).filter(Objects::nonNull).findAny().orElse(null);
        }

        public static interface Tank<T extends Event> {
            public String name();

            default public Scale scale() {
                List sources = this.sources().collect(Collectors.toList());
                return sources.isEmpty() ? null : ((Source)sources.get(0)).scale();
            }

            public Source<T> source(String var1);

            public Stream<Source<T>> sources();

            default public Stream<T> content() {
                return EventStream.merge(this.sources().map(s -> EventStream.sequence(s.tubs().map(Tub::eventSupplier).collect(Collectors.toList()))));
            }

            default public Stream<T> content(BiPredicate<Source<T>, Timetag> filter) {
                return EventStream.merge(this.sources().map(s -> EventStream.sequence(s.tubs().filter(t2 -> filter.test((Source)s, t2.timetag())).map(Tub::eventSupplier).collect(Collectors.toList()))));
            }
        }

        public static interface Tub<T extends Event> {
            public Timetag timetag();

            public Stream<T> events();

            default public Supplier<Stream<T>> eventSupplier() {
                return this::events;
            }

            default public Scale scale() {
                return this.timetag().scale();
            }

            default public Stream<T> events(Predicate<T> filter) {
                return this.events().filter(filter);
            }

            default public Supplier<Stream<T>> eventSupplier(Predicate<T> filter) {
                return () -> this.events(filter);
            }
        }

        public static interface Source<T extends Event> {
            public String name();

            public Stream<Tub<T>> tubs();

            public Tub<T> first();

            public Tub<T> last();

            public Tub<T> on(Timetag var1);

            default public Scale scale() {
                return this.first().timetag().scale();
            }

            default public Stream<Tub<T>> tubs(Timetag from, Timetag to) {
                return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
            }
        }
    }
}

