package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.framework.Activity;

import javax.jms.JMSException;
import javax.jms.Message;

public class UninstallActivityRequest extends ContainerRequest {
	public static final String ID = "uninstallActivity";
	private final ContainerBox box;
	private final Activity.Context context;

	public UninstallActivityRequest(ContainerBox box, Activity.Context context) {
		this.box = box;
		this.context = context;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		try {
			String activityId = activity(request);
			if (activityId == null) return new RequestResult(false, "Activity not found");
			Boolean enabled = box.activities().activities().get(activityId);
			if (enabled) {
				Logger.warn("The activity " + activityId + " could no be uninstalled. It was enabled. Please disable first.");
				return new RequestResult(false, "The activity " + activityId + " could no be uninstalled. It was enabled. Please disable first.");
			}
			boolean b = box.activities().uninstallActivity(activityId);
			new Thread(() -> new ObserverAssertionAction(box, context).execute()).start();
			return new RequestResult(b, b ? "Activity uninstalled" : "Impossible to uninstall activity " + activityId);
		} catch (JMSException e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}