package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.framework.Activity;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class InstallActivityRequest extends ContainerRequest {
	public static final String ID = "installActivity";
	private final ContainerBox box;
	private final Activity.Context context;

	public InstallActivityRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
		this.context = context;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		BytesMessage message = (BytesMessage) request;
		try {
			String artifact = activity(request);
			if (box.activities().enabledActivities().contains(artifact))
				return new RequestResult(true, "Activity already enabled");
			install(message, artifact);
			new Thread(() -> new ObserverAssertionAction(box, context).execute(), artifact + "-install").start();
			return new RequestResult(true, "Activity installed");
		} catch (JMSException e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}

	private void install(BytesMessage message, String artifact) throws JMSException {
		byte[] payload = new byte[(int) message.getBodyLength()];
		message.readBytes(payload);
		box.activities().installActivity(artifact, payload);
	}
}