package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;

import javax.jms.Message;

public class GetActivityConfigurationRequest extends ContainerRequest {
	public static final String ID = "activityConfiguration";
	private final ContainerBox box;
	private final ContainerStore store;

	public GetActivityConfigurationRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
		this.store = store;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		try {
			String activityId = activity(request);
			if (activityId == null) return null;
			box.save();
			return new RequestResult(true, store.activityParams(activityId));
		} catch (Throwable e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}