package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;

import javax.jms.Message;
import java.util.Map;

public class FactoryResetRequest implements RequestAttendant {
	public static final String ID = "factoryReset";
	private final ContainerBox box;
	private final ContainerStore store;

	public FactoryResetRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
		this.store = store;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message message) {
		try {
			Logger.info("Factory reset requested...");
			Map<String, Boolean> activities = box.activities().activities();
			Boolean allUninstalled = activities.keySet().stream()
					.map(k -> uninstall(activities, k))
					.reduce((a1, a2) -> a1 && a2)
					.orElse(true);
			if (allUninstalled) {
				store.clear();
				store.save();
				Logger.info("Factory reset done");
			} else Logger.warn("Impossible to uninstall all activities");
			return new RequestResult(allUninstalled, "Factory reset done");
		} catch (Exception e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}

	private boolean uninstall(Map<String, Boolean> activities, String k) {
		if (activities.get(k)) box.activities().disableActivity(k);
		boolean uninstalled = box.activities().uninstallActivity(k);
		if (!uninstalled) Logger.warn("Impossible to uninstall " + k);
		return uninstalled;
	}
}