package io.intino.consul.container.box.service.requests;

import io.intino.consul.terminal.RequestAttendant;

import javax.jms.JMSException;
import javax.jms.Message;
import java.util.Map;

public abstract class ContainerRequest implements RequestAttendant {

	protected Map<String, Object> activityParameters(Message request) throws JMSException {
		Map<String, Object> parameters = parameters(request);
		parameters.remove("activity");
		return parameters;
	}

	protected String activity(Message request) throws JMSException {
		return parameters(request).get("activity").toString();
	}
}
