package io.intino.consul.container.box.os.remote.linux;

import io.intino.consul.framework.Activity.System.OSProcess.State;

public class Util {

	static boolean isBlank(String s) {
		return s == null || s.isEmpty();
	}

	static long parseLongOrDefault(String s, long defaultLong) {
		try {
			return Long.parseLong(s);
		} catch (NumberFormatException e) {
			return defaultLong;
		}
	}

	public static State getState(char stateValue) {
		return switch (stateValue) {
			case 'R' -> State.RUNNING;
			case 'S' -> State.SLEEPING;
			case 'D' -> State.WAITING;
			case 'Z' -> State.ZOMBIE;
			case 'T' -> State.STOPPED;
			default -> State.OTHER;
		};
	}

}
