package io.intino.consul.container.box.activity;

import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;

import java.lang.reflect.Type;
import java.util.stream.Stream;

public class ActivityStore implements Activity.Store {
	private final ContainerStore store;
	private final String prefix;

	public ActivityStore(String activityID, ContainerStore store) {
		this.store = store;
		this.prefix = activityID + Separator;
	}

	@Override
	public void put(String key, Object object) {
		store.put(prefix + key, object);
	}

	@Override
	public <T> T get(String key, Class<T> aClass) {
		return store.get(prefix + key, aClass);
	}

	@Override
	public <T> T get(String key, Type type) {
		return store.get(prefix + key, type);
	}

	@Override
	public Stream<String> keys() {
		return store.keys().filter(k -> k.startsWith(prefix)).map(k -> k.replace(prefix, ""));
	}

	@Override
	public void remove(String key) {
		store.remove(prefix + key);
	}
}
