package io.intino.consul.container.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.model.Info;
import io.intino.consul.framework.Activity;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;

import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;


public class ComputerAssertionAction {
	public ContainerBox box;
	private Activity.Context context;

	public void execute() {
		context = box.context();
		final ComputerAssertion newInfo = computerInfo();
		final Info last = last();
		if (!hasChanges(last, newInfo)) return;
		if (context.terminal() != null) {
			sleep(1000);
			context.terminal().publish(newInfo);
		}
		if (last == null && context.terminal() != null) context.terminal().publish(status(List.of("line")));
		box.store().put("info", map(newInfo));
	}

	private Status status(List<String> signals) {
		return new Status(context.observer())
				.observable(context.hostName())
				.group("line")
				.signals(signals);
	}

	private boolean hasChanges(Info last, ComputerAssertion newInfo) {
		return last == null
				|| last.diskSize() != newInfo.diskSize()
				|| last.memorySize() != newInfo.memorySize()
				|| last.maxOpenFiles() != newInfo.maxOpenFiles()
				|| !last.localIps().equals(newInfo.ip())
				|| !last.publicIp().equals(newInfo.publicIp())
				|| !Objects.equals(newInfo.jvm(), last.jvm());
	}

	private Info last() {
		return box.store().get("info", Info.class);
	}

	private void sleep(int i) {
		try {
			Thread.sleep(i);
		} catch (InterruptedException e) {
			Logger.error(e);
		}
	}

	private Info map(ComputerAssertion newInfo) {
		return new Info(newInfo.ip(), newInfo.publicIp(), newInfo.cores(), newInfo.diskSize(), newInfo.memorySize(), newInfo.maxOpenFiles(), newInfo.jvm());
	}

	private ComputerAssertion computerInfo() {
		Activity.System system = context.system();
		return (ComputerAssertion) new ComputerAssertion(context.observer() + "." + system.name(), system.name()).
				ts(Instant.now())
				.isp(system.network().ISP())
				.os(System.getProperty("os.name"))
				.maxOpenFiles(system.hdd().maxOpenFiles())
				.cores(system.cpu().cores())
				.diskSize(system.hdd().capacityMB())
				.memorySize(system.ram().capacityMB())
				.architecture(System.getProperty("os.arch"))
				.jvm(findInstalledJVM())
				.publicIp(system.network().publicIP())
				.ip(List.of(system.network().localIP()))
				.observer(box.observer());
	}

	private String findInstalledJVM() {
		try {
			Process java = new ProcessBuilder("java", "--version").start();
			Thread.sleep(1000);
			BufferedReader reader = java.inputReader();
			List<String> lines = reader.lines().toList();
			reader.close();
			if (!lines.isEmpty()) return lines.get(0);
		} catch (IOException | InterruptedException e) {
			Logger.error(e);
		}
		return null;
	}
}