package io.intino.consul.container.box;

import io.intino.alexandria.logger.Logger;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.jar.Manifest;

public class Utils {
	public static String calculateHostName() {
		try {
			return InetAddress.getLocalHost().getHostName().replace(".", "-");
		} catch (UnknownHostException e) {
			Logger.error(e.getMessage());
			return "consul-default-server";
		}
	}

	public static long inMb(long value) {
		return value / (1024 * 1024);
	}

	private static double asPercent(double number) {
		return Math.floor(number * 100) / 100;
	}

	public static String currentVersion() {
		try {
			String file = Utils.class.getProtectionDomain().getCodeSource().getLocation().getFile();
			if (isWindows()) {
				file = file.replace("%20", " ");
				if (file.startsWith("/")) file = file.substring(1);
			}
			if (new File(file).isFile()) {
				URL url = new URL("jar:file:" + file + "!/META-INF/MANIFEST.MF");
				Manifest manifest = new Manifest(url.openStream());
				String version = manifest.getMainAttributes().getValue("Implementation-Version");
				if (version != null) return version.trim();
			}
		} catch (IOException e) {
			Logger.error(e);
		}
		return "1.0.0";
	}


	public enum OS {osx, windows, linux}

	public static boolean isWindows() {
		return (System.getProperty("os.name").toLowerCase().contains("win"));
	}

	public static boolean isMac() {
		return (System.getProperty("os.name").toLowerCase().contains("mac"));
	}

	public static boolean isUnix() {
		return (System.getProperty("os.name").toLowerCase().contains("nix") || System.getProperty("os.name").toLowerCase().contains("nux") || System.getProperty("os.name").toLowerCase().indexOf("aix") > 0);
	}

	public static boolean isSolaris() {
		return (System.getProperty("os.name").toLowerCase().contains("sunos"));
	}

	public static OS operatingSystem() {
		if (isMac()) return OS.osx;
		if (isWindows()) return OS.windows;
		return OS.linux;
	}
}
